% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendallW.r
\name{kendallW}
\alias{kendallW}
\title{Kendall's W with bootstrapped confidence interval}
\usage{
kendallW(
  x,
  correct = TRUE,
  na.rm = FALSE,
  ci = FALSE,
  conf = 0.95,
  type = "perc",
  R = 1000,
  histogram = FALSE,
  digits = 3,
  ...
)
}
\arguments{
\item{x}{A k x m matrix or table, with k treatments in rows 
and m raters or blocks in columns.}

\item{correct}{Passed to \code{KendallW}.}

\item{na.rm}{Passed to \code{KendallW}.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{digits}{The number of significant digits in the output.}

\item{...}{Additional arguments passed to the \code{KendallW} function.}
}
\value{
A single statistic, W.  
        Or a small data frame consisting of W,
        and the lower and upper confidence limits.
}
\description{
Calculates Kendall's W coefficient of concordance,
             which can be used as an effect size statistic for
             unreplicated complete block design
             such as where Friedman's test might be used.
             This function is a wrapper for the \code{KendallW}
             function in the \code{DescTools} package,
             with the addition of bootstrapped
             confidence intervals.
}
\details{
See the \code{KendallW} function in the \code{DescTools} package
          for details.
          
          When W is close to 0 or very large,
          or with small sample size,
          the confidence intervals 
          determined by this
          method may not be reliable, or the procedure may fail.
          
          Because W is always positive, if \code{type="perc"},
          the confidence interval will
          never cross zero, and should not
          be used for statistical inference.
          However, if \code{type="norm"}, the confidence interval
          may cross zero. 
          
          When producing confidence intervals by bootstrap, 
          this function treats each rater or block as an observation.
          It is not clear to the author if this approach produces accurate
          confidence intervals, but it appears to be reasonable.
}
\section{Acknowledgments}{

 My thanks to Indrajeet Patil, author of \code{ggstatsplot},
 and \code{groupedstats} for help in the inspiring and 
 coding of this function.
}

\examples{
data(BobBelcher)
Table = xtabs(Likert ~ Instructor + Rater, data = BobBelcher)
kendallW(Table)

}
\references{
\url{http://rcompanion.org/handbook/F_10.html}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{Friedman's test}
\concept{Kendall's W}
\concept{confidence interval}
\concept{effect size}
