% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohenG.r
\name{cohenG}
\alias{cohenG}
\title{Cohen's g and odds ratio for paired contingency tables}
\usage{
cohenG(x, ci = FALSE, conf = 0.95, type = "perc", R = 1000,
  histogram = FALSE, digits = 3)
}
\arguments{
\item{x}{A two-way contingency table. It must be square. 
It can have two or
more levels for each dimension.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{digits}{The number of significant digits in the output.}
}
\value{
A list containing: a data frame of results of the global statistics;
        and a data frame of results of the pairwise statistics.
}
\description{
Calculates Cohen's g and odds ratio
             for paired contingency tables, such as those that 
             might be analyzed with   
             McNemar or McNemar-Bowker tests.
}
\details{
For a 2 x 2 table, where a and d are the concordant cells
         and b and c are discordant cells:
         Odds ratio is the greater of b/c or c/b;
         P is the greater of b/(b+c) or c/(b+c);
         and Cohen's g is P - 0.5.
         These statistics are extended to tables larger
         than 2 x 2.
         
          When the reported statistics are close to their extremes,
          or with small counts, 
          the confidence intervals 
          determined by this
          method may not be reliable, or the procedure may fail.
}
\examples{
### 2 x 2 repeated matrix example
data(AndersonRainBarrel)
cohenG(AndersonRainBarrel)
                    
### 3 x 3 repeated matrix
data(AndersonRainGarden)
cohenG(AndersonRainGarden)

}
\references{
\url{http://rcompanion.org/handbook/H_05.html}
}
\seealso{
\code{\link{nominalSymmetryTest}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{Effect size Cohen g McNemar Bowker contingency symmetry nominal}
