% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwisePermutationSymmetry.r
\name{pairwisePermutationSymmetry}
\alias{pairwisePermutationSymmetry}
\title{Pairwise two-sample permutation symmetry tests}
\usage{
pairwisePermutationSymmetry(x, g, b, method = "fdr", ...)
}
\arguments{
\item{x}{The response variable as a vector.}

\item{g}{The grouping variable as a vector.}

\item{b}{The blocking variable as a vector.}

\item{method}{The p-value adjustment method to use for multiple tests.
See \code{\link{p.adjust}}.}

\item{...}{Additional arguments passed to
\code{\link{symmetry_test}}.}
}
\value{
A dataframe of the groups being compared, the p-values,
        and the adjusted p-values.
}
\description{
Conducts pairwise two-sample permutation tests 
             of symmetry across groups.
}
\details{
Permutation tests are non-parametric tests 
         that do not assume normally-distributed errors.
         See \url{http://rcompanion.org/rcompanion/d_06a.html} for
         futher discussion of this test.

         The \code{pairwisePermutationSymmetry} function
         can be used as a post-hoc method following an omnibus 
         permutation test
         analogous to a paired one-way analysis of variance.
}
\examples{
data(BobBelcher)
BobBelcher$Instructor = factor(BobBelcher$Instructor, 
                               levels=c("Linda Belcher", "Louise Belcher",
                                 "Tina Belcher", "Bob Belcher",
                                 "Gene Belcher"))
BobBelcher$Likert.f = factor(BobBelcher$Likert, ordered=TRUE)
PT = pairwisePermutationSymmetry(x      = BobBelcher$Likert.f,
                                 g      = BobBelcher$Instructor,
                                 b      = BobBelcher$Rater,
                                 method = "fdr")
PT
cldList(comparison = PT$Comparison,
        p.value    = PT$p.adjust,
        threshold  = 0.05)

}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/handbook/K_03.html}
}
\seealso{
\code{\link{pairwisePermutationSymmetryMatrix}}
}
\concept{
permutation nonparametric post-hoc one-way symmetry
}

