% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sppplus_taxonconcept.R
\name{sppplus_taxonconcept}
\alias{sppplus_taxonconcept}
\title{Get taxon concepts for a search term.}
\usage{
sppplus_taxonconcept(query_taxon, appendix_only = FALSE, token = NULL)
}
\arguments{
\item{query_taxon}{a character string containing the query (e.g. species). Scientific taxa only (max 255 characters).}

\item{appendix_only}{a logical. If \code{TRUE} then taxon identifier and the
CITES appendix information are the only data returned (default is \code{FALSE}).}

\item{token}{a character string containing the authentification token, see
\url{https://api.speciesplus.net/documentation}. Default is set to
\code{NULL} and requires the environment variable \code{SPPPLUS_TOKEN} to be
set directly in \code{Renviron}. Alternatively, \code{sppplus_login()} can
be used to set \code{SPPPLUS_TOKEN} for the current session.}
}
\value{
If \code{appendix_only} is \code{TRUE}, then a data frame with a species'
taxon id and CITES appendix information is returned. Otherwise, a list of
objects of class \code{data.table} with all CITES Species+ taxon_concept
information is returned. Importantly enough, this functions returns the
taxon concept identifier that is required by the \code{taxon_*()} functions.
}
\description{
Retrieve the taxon concept of a specific taxon (scientific name).
}
\examples{
\donttest{
res1 <- sppplus_taxonconcept(query_taxon = 'Loxodonta africana')
res2 <- sppplus_taxonconcept(query_taxon = 'Loxodonta africana', appendix_only = TRUE)
res3 <- sppplus_taxonconcept(query_taxon = 'Amazilia versicolor')
}
}
\references{
\url{https://api.speciesplus.net/documentation/v1/taxon_concepts/index.html}
}
