/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class KappaShapeIndicesDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final String[] NAMES = new String[]{"Kier1", "Kier2", "Kier3"};

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#kierValues", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
    }

    public Object[] getParameters() {
        return null;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    public DescriptorValue calculate(IAtomContainer container) {
        double kier3;
        double kier2;
        double kier1;
        IAtomContainer atomContainer;
        try {
            atomContainer = container.clone();
        }
        catch (CloneNotSupportedException e) {
            DoubleArrayResult kierValues = new DoubleArrayResult(3);
            kierValues.add(Double.NaN);
            kierValues.add(Double.NaN);
            kierValues.add(Double.NaN);
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)kierValues, this.getDescriptorNames());
        }
        atomContainer = AtomContainerManipulator.removeHydrogens((IAtomContainer)atomContainer);
        DoubleArrayResult kierValues = new DoubleArrayResult(3);
        double atomsCount = atomContainer.getAtomCount();
        ArrayList<Double> singlePaths = new ArrayList<Double>();
        ArrayList<String> doublePaths = new ArrayList<String>();
        ArrayList<String> triplePaths = new ArrayList<String>();
        double[] sorterFirst = new double[2];
        double[] sorterSecond = new double[3];
        int a1 = 0;
        while ((double)a1 < atomsCount) {
            double bond1 = 0.0;
            List firstAtomNeighboors = atomContainer.getConnectedAtomsList(atomContainer.getAtom(a1));
            for (Object firstAtomNeighboor : firstAtomNeighboors) {
                bond1 = atomContainer.indexOf(atomContainer.getBond(atomContainer.getAtom(a1), (IAtom)firstAtomNeighboor));
                if (!singlePaths.contains(bond1)) {
                    singlePaths.add(bond1);
                    Collections.sort(singlePaths);
                }
                List secondAtomNeighboors = atomContainer.getConnectedAtomsList((IAtom)firstAtomNeighboor);
                for (Object secondAtomNeighboor : secondAtomNeighboors) {
                    double bond2 = atomContainer.indexOf(atomContainer.getBond((IAtom)firstAtomNeighboor, (IAtom)secondAtomNeighboor));
                    if (!singlePaths.contains(bond2)) {
                        singlePaths.add(bond2);
                    }
                    sorterFirst[0] = bond1;
                    sorterFirst[1] = bond2;
                    Arrays.sort(sorterFirst);
                    String tmpbond2 = sorterFirst[0] + "+" + sorterFirst[1];
                    if (!doublePaths.contains(tmpbond2) && bond1 != bond2) {
                        doublePaths.add(tmpbond2);
                    }
                    List thirdAtomNeighboors = atomContainer.getConnectedAtomsList((IAtom)secondAtomNeighboor);
                    for (Object thirdAtomNeighboor : thirdAtomNeighboors) {
                        double bond3 = atomContainer.indexOf(atomContainer.getBond((IAtom)secondAtomNeighboor, (IAtom)thirdAtomNeighboor));
                        if (!singlePaths.contains(bond3)) {
                            singlePaths.add(bond3);
                        }
                        sorterSecond[0] = bond1;
                        sorterSecond[1] = bond2;
                        sorterSecond[2] = bond3;
                        Arrays.sort(sorterSecond);
                        String tmpbond3 = sorterSecond[0] + "+" + sorterSecond[1] + "+" + sorterSecond[2];
                        if (triplePaths.contains(tmpbond3) || bond1 == bond2 || bond1 == bond3 || bond2 == bond3) continue;
                        triplePaths.add(tmpbond3);
                    }
                }
            }
            ++a1;
        }
        if (atomsCount == 1.0) {
            kier1 = 0.0;
            kier2 = 0.0;
            kier3 = 0.0;
        } else {
            kier1 = atomsCount * ((atomsCount - 1.0) * (atomsCount - 1.0)) / (double)(singlePaths.size() * singlePaths.size());
            if (atomsCount == 2.0) {
                kier2 = 0.0;
                kier3 = 0.0;
            } else {
                kier2 = doublePaths.size() == 0 ? Double.NaN : (atomsCount - 1.0) * ((atomsCount - 2.0) * (atomsCount - 2.0)) / (double)(doublePaths.size() * doublePaths.size());
                kier3 = atomsCount == 3.0 ? 0.0 : (atomsCount % 2.0 != 0.0 ? (triplePaths.size() == 0 ? Double.NaN : (atomsCount - 1.0) * ((atomsCount - 3.0) * (atomsCount - 3.0)) / (double)(triplePaths.size() * triplePaths.size())) : (triplePaths.size() == 0 ? Double.NaN : (atomsCount - 3.0) * ((atomsCount - 2.0) * (atomsCount - 2.0)) / (double)(triplePaths.size() * triplePaths.size())));
            }
        }
        kierValues.add(kier1);
        kierValues.add(kier2);
        kierValues.add(kier3);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)kierValues, this.getDescriptorNames());
    }

    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(3);
    }

    public String[] getParameterNames() {
        return null;
    }

    public Object getParameterType(String name) {
        return null;
    }
}

