/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash.stereo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.hash.stereo.BasicPermutationParity;
import org.openscience.cdk.hash.stereo.GeometricParity;
import org.openscience.cdk.hash.stereo.GeometryEncoder;
import org.openscience.cdk.hash.stereo.MultiStereoEncoder;
import org.openscience.cdk.hash.stereo.PermutationParity;
import org.openscience.cdk.hash.stereo.StereoEncoder;
import org.openscience.cdk.hash.stereo.StereoEncoderFactory;
import org.openscience.cdk.hash.stereo.Tetrahedral2DParity;
import org.openscience.cdk.hash.stereo.Tetrahedral3DParity;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;

public class GeometricTetrahedralEncoderFactory
implements StereoEncoderFactory {
    @Override
    public StereoEncoder create(IAtomContainer container, int[][] graph) {
        int n = container.getAtomCount();
        ArrayList<StereoEncoder> encoders = new ArrayList<StereoEncoder>();
        HashMap<IAtom, Integer> elevation = new HashMap<IAtom, Integer>(10);
        for (int i = 0; i < n; ++i) {
            List bonds;
            GeometricParity geometric;
            IAtom atom;
            int degree = graph[i].length;
            if (degree < 3 || degree > 4 || !GeometricTetrahedralEncoderFactory.sp3(atom = container.getAtom(i)) || Integer.valueOf(7).equals(atom.getAtomicNumber()) && degree == 3 || (geometric = GeometricTetrahedralEncoderFactory.geometric(elevation, bonds = container.getConnectedBondsList(atom), i, graph[i], container)) == null) continue;
            encoders.add(new GeometryEncoder(i, (PermutationParity)new BasicPermutationParity(graph[i]), geometric));
        }
        return encoders.isEmpty() ? StereoEncoder.EMPTY : new MultiStereoEncoder(encoders);
    }

    private static GeometricParity geometric(Map<IAtom, Integer> elevationMap, List<IBond> bonds, int i, int[] adjacent, IAtomContainer container) {
        int nStereoBonds = GeometricTetrahedralEncoderFactory.nStereoBonds(bonds);
        if (nStereoBonds > 0) {
            return GeometricTetrahedralEncoderFactory.geometric2D(elevationMap, bonds, i, adjacent, container);
        }
        if (nStereoBonds == 0) {
            return GeometricTetrahedralEncoderFactory.geometric3D(i, adjacent, container);
        }
        return null;
    }

    private static GeometricParity geometric2D(Map<IAtom, Integer> elevationMap, List<IBond> bonds, int i, int[] adjacent, IAtomContainer container) {
        IAtom atom = container.getAtom(i);
        GeometricTetrahedralEncoderFactory.makeElevationMap(atom, bonds, elevationMap);
        Point2d[] coordinates = new Point2d[4];
        int[] elevations = new int[4];
        if (atom.getPoint2d() == null) {
            return null;
        }
        coordinates[3] = atom.getPoint2d();
        for (int j = 0; j < adjacent.length; ++j) {
            IAtom neighbor = container.getAtom(adjacent[j]);
            elevations[j] = elevationMap.get(neighbor);
            if (neighbor.getPoint2d() == null) {
                return null;
            }
            coordinates[j] = neighbor.getPoint2d();
        }
        return new Tetrahedral2DParity(coordinates, elevations);
    }

    private static GeometricParity geometric3D(int i, int[] adjacent, IAtomContainer container) {
        IAtom atom = container.getAtom(i);
        Point3d[] coordinates = new Point3d[4];
        if (atom.getPoint3d() == null) {
            return null;
        }
        coordinates[3] = atom.getPoint3d();
        for (int j = 0; j < adjacent.length; ++j) {
            IAtom neighbor = container.getAtom(adjacent[j]);
            if (neighbor.getPoint3d() == null) {
                return null;
            }
            coordinates[j] = neighbor.getPoint3d();
        }
        return new Tetrahedral3DParity(coordinates);
    }

    private static boolean sp3(IAtom atom) {
        return IAtomType.Hybridization.SP3.equals((Object)atom.getHybridization());
    }

    private static int nStereoBonds(List<IBond> bonds) {
        int count = 0;
        for (IBond bond : bonds) {
            IBond.Stereo stereo = bond.getStereo();
            switch (stereo) {
                case E_OR_Z: 
                case UP_OR_DOWN: 
                case UP_OR_DOWN_INVERTED: {
                    return -1;
                }
                case UP: 
                case DOWN: 
                case UP_INVERTED: 
                case DOWN_INVERTED: {
                    ++count;
                }
            }
        }
        return count;
    }

    private static void makeElevationMap(IAtom atom, List<IBond> bonds, Map<IAtom, Integer> map) {
        map.clear();
        for (IBond bond : bonds) {
            int elevation = 0;
            switch (bond.getStereo()) {
                case UP: 
                case DOWN_INVERTED: {
                    elevation = 1;
                    break;
                }
                case DOWN: 
                case UP_INVERTED: {
                    elevation = -1;
                }
            }
            if (bond.getBegin().equals((Object)atom)) {
                map.put(bond.getEnd(), elevation);
                continue;
            }
            map.put(bond.getBegin(), -1 * elevation);
        }
    }
}

