/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.rebond;

import java.util.Enumeration;

public final class Bspt {
    private static final int LEAF_COUNT = 4;
    private static final int STACK_DEPTH = 64;
    final int dimMax;
    Element eleRoot;

    public Bspt(int dimMax) {
        this.dimMax = dimMax;
        this.eleRoot = new Leaf();
    }

    public void addTuple(Tuple tuple) {
        if (!this.eleRoot.addTuple(tuple)) {
            this.eleRoot = new Node(0, this.dimMax, (Leaf)this.eleRoot);
            if (!this.eleRoot.addTuple(tuple)) {
                throw new Error("Bspt.addTuple() failed");
            }
        }
    }

    public String toString() {
        return this.eleRoot.toString();
    }

    protected void dump() {
        this.eleRoot.dump(0);
    }

    protected Enumeration enumeration() {
        return new EnumerateAll();
    }

    protected Enumeration enumNear(Tuple center, double distance) {
        return new EnumerateNear(center, distance);
    }

    protected EnumerateSphere enumSphere(Tuple center, double distance) {
        return new EnumerateSphere(center, distance, false);
    }

    protected EnumerateSphere enumHemiSphere(Tuple center, double distance) {
        return new EnumerateSphere(center, distance, true);
    }

    class Leaf
    implements Element {
        int count = 0;
        final Tuple[] tuples = new Tuple[4];

        Leaf() {
        }

        Leaf(Leaf leaf, int dim, double splitValue) {
            this();
            int i = 4;
            while (--i >= 0) {
                Tuple tuple = leaf.tuples[i];
                double value = tuple.getDimValue(dim);
                if (!(value > splitValue) && (value != splitValue || (i & 1) != 1)) continue;
                leaf.tuples[i] = null;
                this.tuples[this.count++] = tuple;
            }
            int dest = 0;
            for (int src = 0; src < 4; ++src) {
                if (leaf.tuples[src] == null) continue;
                leaf.tuples[dest++] = leaf.tuples[src];
            }
            leaf.count = dest;
            if (this.count == 0) {
                this.tuples[4] = null;
            }
        }

        public double getSplitValue(int dim) {
            if (this.count != 4) {
                this.tuples[4] = null;
            }
            return (this.tuples[0].getDimValue(dim) + this.tuples[3].getDimValue(dim)) / 2.0;
        }

        public String toString() {
            return "leaf:" + this.count + "\n";
        }

        @Override
        public boolean addTuple(Tuple tuple) {
            if (this.count == 4) {
                return false;
            }
            this.tuples[this.count++] = tuple;
            return true;
        }

        @Override
        public void dump(int level) {
            for (int i = 0; i < this.count; ++i) {
                Tuple t = this.tuples[i];
                for (int j = 0; j < level; ++j) {
                    System.out.print(".");
                }
                for (int dim = 0; dim < Bspt.this.dimMax - 1; ++dim) {
                    System.out.print("" + t.getDimValue(dim) + ",");
                }
                System.out.println("" + t.getDimValue(Bspt.this.dimMax - 1));
            }
        }

        @Override
        public boolean isLeafWithSpace() {
            return this.count < 4;
        }
    }

    static interface Element {
        public boolean addTuple(Tuple var1);

        public void dump(int var1);

        public boolean isLeafWithSpace();
    }

    public static interface Tuple {
        public double getDimValue(int var1);
    }

    class Node
    implements Element {
        Element eleLE;
        final int dim;
        final int dimMax;
        final double splitValue;
        Element eleGE;

        Node(int dim, int dimMax, Leaf leafLE) {
            this.eleLE = leafLE;
            this.dim = dim;
            this.dimMax = dimMax;
            this.splitValue = leafLE.getSplitValue(dim);
            this.eleGE = new Leaf(leafLE, dim, this.splitValue);
        }

        @Override
        public boolean addTuple(Tuple tuple) {
            if (tuple.getDimValue(this.dim) < this.splitValue) {
                if (this.eleLE.addTuple(tuple)) {
                    return true;
                }
                this.eleLE = new Node((this.dim + 1) % this.dimMax, this.dimMax, (Leaf)this.eleLE);
                return this.eleLE.addTuple(tuple);
            }
            if (tuple.getDimValue(this.dim) > this.splitValue) {
                if (this.eleGE.addTuple(tuple)) {
                    return true;
                }
                this.eleGE = new Node((this.dim + 1) % this.dimMax, this.dimMax, (Leaf)this.eleGE);
                return this.eleGE.addTuple(tuple);
            }
            if (this.eleLE.isLeafWithSpace()) {
                this.eleLE.addTuple(tuple);
            } else if (this.eleGE.isLeafWithSpace()) {
                this.eleGE.addTuple(tuple);
            } else if (this.eleLE instanceof Node) {
                this.eleLE.addTuple(tuple);
            } else if (this.eleGE instanceof Node) {
                this.eleGE.addTuple(tuple);
            } else {
                this.eleLE = new Node((this.dim + 1) % this.dimMax, this.dimMax, (Leaf)this.eleLE);
                return this.eleLE.addTuple(tuple);
            }
            return true;
        }

        public String toString() {
            return this.eleLE.toString() + this.dim + ":" + this.splitValue + "\n" + this.eleGE.toString();
        }

        @Override
        public void dump(int level) {
            System.out.println("");
            this.eleLE.dump(level + 1);
            for (int i = 0; i < level; ++i) {
                System.out.print("-");
            }
            System.out.println(">" + this.splitValue);
            this.eleGE.dump(level + 1);
        }

        @Override
        public boolean isLeafWithSpace() {
            return false;
        }
    }

    class EnumerateAll
    implements Enumeration {
        final Node[] stack = new Node[64];
        int sp = 0;
        int i;
        Leaf leaf;

        EnumerateAll() {
            Element ele = Bspt.this.eleRoot;
            while (ele instanceof Node) {
                Node node = (Node)ele;
                if (this.sp == 64) {
                    throw new Error("Bspt.EnumerateAll tree stack overflow");
                }
                this.stack[this.sp++] = node;
                ele = node.eleLE;
            }
            this.leaf = (Leaf)ele;
            this.i = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.i < this.leaf.count || this.sp > 0;
        }

        public Object nextElement() {
            if (this.i == this.leaf.count) {
                Element ele = this.stack[--this.sp].eleGE;
                while (ele instanceof Node) {
                    Node node = (Node)ele;
                    this.stack[this.sp++] = node;
                    ele = node.eleLE;
                }
                this.leaf = (Leaf)ele;
                this.i = 0;
            }
            return this.leaf.tuples[this.i++];
        }
    }

    class EnumerateNear
    implements Enumeration {
        final Node[] stack;
        int sp;
        int i;
        Leaf leaf;
        final double distance;
        final Tuple center;

        EnumerateNear(Tuple center, double distance) {
            this.distance = distance;
            this.center = center;
            this.stack = new Node[64];
            this.sp = 0;
            Element ele = Bspt.this.eleRoot;
            while (ele instanceof Node) {
                Node node = (Node)ele;
                if (center.getDimValue(node.dim) - distance <= node.splitValue) {
                    if (this.sp == 64) {
                        throw new Error("Bspt.EnumerateNear tree stack overflow");
                    }
                    this.stack[this.sp++] = node;
                    ele = node.eleLE;
                    continue;
                }
                ele = node.eleGE;
            }
            this.leaf = (Leaf)ele;
            this.i = 0;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.i < this.leaf.count) {
                return true;
            }
            if (this.sp == 0) {
                return false;
            }
            Element ele = this.stack[--this.sp];
            while (ele instanceof Node) {
                Node node = ele;
                if (this.center.getDimValue(node.dim) + this.distance < node.splitValue) {
                    if (this.sp == 0) {
                        return false;
                    }
                    ele = this.stack[--this.sp];
                    continue;
                }
                ele = node.eleGE;
                while (ele instanceof Node) {
                    Element nodeLeft = ele;
                    this.stack[this.sp++] = nodeLeft;
                    ele = nodeLeft.eleLE;
                }
            }
            this.leaf = (Leaf)ele;
            this.i = 0;
            return true;
        }

        public Object nextElement() {
            return this.leaf.tuples[this.i++];
        }
    }

    class EnumerateSphere
    implements Enumeration {
        final Node[] stack;
        int sp;
        int i;
        Leaf leaf;
        final double distance;
        final double distance2;
        final Tuple center;
        final double[] centerValues;
        double foundDistance2;
        final boolean tHemisphere;

        EnumerateSphere(Tuple center, double distance, boolean tHemisphere) {
            this.distance = distance;
            this.distance2 = distance * distance;
            this.center = center;
            this.tHemisphere = tHemisphere;
            this.centerValues = new double[Bspt.this.dimMax];
            int dim = Bspt.this.dimMax;
            while (--dim >= 0) {
                this.centerValues[dim] = center.getDimValue(dim);
            }
            this.stack = new Node[64];
            this.sp = 0;
            Element ele = Bspt.this.eleRoot;
            while (ele instanceof Node) {
                Node node = (Node)ele;
                if (center.getDimValue(node.dim) - distance <= node.splitValue) {
                    if (this.sp == 64) {
                        throw new Error("Bspt.EnumerateSphere tree stack overflow");
                    }
                    this.stack[this.sp++] = node;
                    ele = node.eleLE;
                    continue;
                }
                ele = node.eleGE;
            }
            this.leaf = (Leaf)ele;
            this.i = 0;
        }

        private boolean isWithin(Tuple t) {
            double distT = t.getDimValue(0) - this.centerValues[0];
            if (this.tHemisphere && distT < 0.0) {
                return false;
            }
            double dist2 = distT * distT;
            if (dist2 > this.distance2) {
                return false;
            }
            int dim = Bspt.this.dimMax;
            while (--dim > 0) {
                distT = t.getDimValue(dim) - this.centerValues[dim];
                if (!((dist2 += distT * distT) > this.distance2)) continue;
                return false;
            }
            this.foundDistance2 = dist2;
            return true;
        }

        @Override
        public boolean hasMoreElements() {
            while (true) {
                if (this.i < this.leaf.count) {
                    if (this.isWithin(this.leaf.tuples[this.i])) {
                        return true;
                    }
                    ++this.i;
                    continue;
                }
                if (this.sp == 0) {
                    return false;
                }
                Element ele = this.stack[--this.sp];
                while (ele instanceof Node) {
                    Node node = ele;
                    if (this.center.getDimValue(node.dim) + this.distance < node.splitValue) {
                        if (this.sp == 0) {
                            return false;
                        }
                        ele = this.stack[--this.sp];
                        continue;
                    }
                    ele = node.eleGE;
                    while (ele instanceof Node) {
                        Element nodeLeft = ele;
                        this.stack[this.sp++] = nodeLeft;
                        ele = nodeLeft.eleLE;
                    }
                }
                this.leaf = (Leaf)ele;
                this.i = 0;
            }
        }

        public Object nextElement() {
            return this.leaf.tuples[this.i++];
        }

        public double foundDistance2() {
            return this.foundDistance2;
        }
    }
}

