/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers;

import java.util.HashMap;
import org.openscience.cdk.AtomRef;
import org.openscience.cdk.BondRef;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.isomorphism.matchers.Expr;
import org.openscience.cdk.isomorphism.matchers.QueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryBond;
import org.openscience.cdk.isomorphism.matchers.SymbolChargeIDQueryAtom;

public class QueryAtomContainerCreator {
    public static QueryAtomContainer createBasicQueryContainer(IAtomContainer container) {
        return QueryAtomContainer.create(container, Expr.Type.ALIPHATIC_ELEMENT, Expr.Type.AROMATIC_ELEMENT, Expr.Type.IS_AROMATIC, Expr.Type.ALIPHATIC_ORDER, Expr.Type.STEREOCHEMISTRY);
    }

    public static QueryAtomContainer createSymbolAndBondOrderQueryContainer(IAtomContainer container) {
        return QueryAtomContainer.create(container, Expr.Type.ELEMENT, Expr.Type.ORDER);
    }

    public static QueryAtomContainer createSymbolAndChargeQueryContainer(IAtomContainer container) {
        return QueryAtomContainer.create(container, Expr.Type.ELEMENT, Expr.Type.FORMAL_CHARGE, Expr.Type.IS_AROMATIC, Expr.Type.ORDER);
    }

    public static QueryAtomContainer createSymbolChargeIDQueryContainer(IAtomContainer container) {
        QueryAtomContainer queryContainer = new QueryAtomContainer(container.getBuilder());
        for (int i = 0; i < container.getAtomCount(); ++i) {
            queryContainer.addAtom(new SymbolChargeIDQueryAtom(container.getAtom(i)));
        }
        for (IBond bond : container.bonds()) {
            QueryBond qbond;
            int index1 = container.indexOf(bond.getBegin());
            int index2 = container.indexOf(bond.getEnd());
            if (bond.isAromatic()) {
                qbond = new QueryBond(queryContainer.getAtom(index1), queryContainer.getAtom(index2), Expr.Type.IS_AROMATIC);
                queryContainer.addBond(qbond);
                continue;
            }
            qbond = new QueryBond(queryContainer.getAtom(index1), queryContainer.getAtom(index2), Expr.Type.ORDER, bond.getOrder().numeric());
            qbond.setOrder(bond.getOrder());
            queryContainer.addBond(qbond);
        }
        return queryContainer;
    }

    public static QueryAtomContainer createAnyAtomContainer(IAtomContainer container, boolean aromaticity) {
        if (aromaticity) {
            return QueryAtomContainer.create(container, Expr.Type.IS_AROMATIC, Expr.Type.ALIPHATIC_ORDER);
        }
        return QueryAtomContainer.create(container, Expr.Type.ORDER);
    }

    public static QueryAtomContainer createAnyAtomAnyBondContainer(IAtomContainer container, boolean aromaticity) {
        if (aromaticity) {
            return QueryAtomContainer.create(container, Expr.Type.IS_AROMATIC);
        }
        return QueryAtomContainer.create(container, new Expr.Type[0]);
    }

    public static QueryAtomContainer createAnyAtomForPseudoAtomQueryContainer(IAtomContainer container) {
        return QueryAtomContainer.create(container, Expr.Type.ELEMENT, Expr.Type.IS_AROMATIC, Expr.Type.ALIPHATIC_ORDER);
    }

    static boolean isSimpleHydrogen(Expr expr) {
        switch (expr.type()) {
            case ELEMENT: 
            case ALIPHATIC_ELEMENT: {
                return expr.value() == 1;
            }
        }
        return false;
    }

    public static IAtomContainer suppressQueryHydrogens(IAtomContainer mol) {
        for (IAtom iAtom : mol.atoms()) {
            if (AtomRef.deref(iAtom) instanceof QueryAtom) continue;
            throw new IllegalArgumentException("Non-query atoms found!");
        }
        for (IBond iBond : mol.bonds()) {
            if (BondRef.deref(iBond) instanceof QueryBond) continue;
            throw new IllegalArgumentException("Non-query bonds found!");
        }
        HashMap<IChemObject, IChemObject> plainHydrogens = new HashMap<IChemObject, IChemObject>();
        for (IAtom atom : mol.atoms()) {
            int hcnt = 0;
            for (IAtom nbor : mol.getConnectedAtomsList(atom)) {
                QueryAtom qnbor = (QueryAtom)AtomRef.deref(nbor);
                if (mol.getConnectedBondsCount(nbor) != 1 || !QueryAtomContainerCreator.isSimpleHydrogen(qnbor.getExpression())) continue;
                ++hcnt;
                plainHydrogens.put(nbor, atom);
            }
            if (hcnt <= 0) continue;
            QueryAtom qatom = (QueryAtom)AtomRef.deref(atom);
            Expr e = qatom.getExpression();
            Expr hexpr = new Expr();
            for (int i = 0; i < hcnt; ++i) {
                hexpr.and(new Expr(Expr.Type.TOTAL_H_COUNT, i).negate());
            }
            e.and(hexpr);
        }
        if (plainHydrogens.isEmpty()) {
            return mol;
        }
        QueryAtomContainer queryAtomContainer = new QueryAtomContainer(mol.getBuilder());
        for (IAtom atom : mol.atoms()) {
            if (plainHydrogens.containsKey(atom)) continue;
            queryAtomContainer.addAtom(atom);
        }
        for (IBond bond : mol.bonds()) {
            if (plainHydrogens.containsKey(bond.getBegin()) || plainHydrogens.containsKey(bond.getEnd())) continue;
            queryAtomContainer.addBond(bond);
        }
        for (IStereoElement se : mol.stereoElements()) {
            queryAtomContainer.addStereoElement(se.map(plainHydrogens));
        }
        return queryAtomContainer;
    }
}

