/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.random;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.ISimpleChemObjectReader;
import org.openscience.cdk.io.MDLV2000Reader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLFormat;
import org.openscience.cdk.io.listener.IReaderListener;
import org.openscience.cdk.io.random.RandomAccessReader;

public class RandomAccessSDFReader
extends RandomAccessReader {
    public RandomAccessSDFReader(File file, IChemObjectBuilder builder) throws IOException {
        this(file, builder, null);
    }

    public RandomAccessSDFReader(File file, IChemObjectBuilder builder, IReaderListener listener) throws IOException {
        super(file, builder, listener);
    }

    @Override
    public ISimpleChemObjectReader createChemObjectReader() {
        return new MDLV2000Reader();
    }

    @Override
    protected boolean isRecordEnd(String line) {
        return line.equals("$$$$");
    }

    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return MDLFormat.getInstance();
    }

    @Override
    protected IChemObject processContent() throws CDKException {
        IChemObject co;
        block1: {
            Iterator<IAtomContainer> sm;
            int c;
            int i;
            co = this.chemObjectReader.read((IChemObject)this.builder.newInstance(IChemFile.class, new Object[0]));
            if (!(co instanceof IChemFile) || (i = 0) >= (c = ((IChemFile)co).getChemSequenceCount())) break block1;
            Iterator<IChemModel> cm = ((IChemFile)co).getChemSequence(i).chemModels().iterator();
            if (cm.hasNext() && (sm = cm.next().getMoleculeSet().atomContainers().iterator()).hasNext()) {
                co = sm.next();
            }
            cm = null;
        }
        return co;
    }

    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) throws CDKException {
        throw new UnsupportedOperationException();
    }

    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream reader) throws CDKException {
        throw new UnsupportedOperationException();
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class<? extends IChemObject> classObject) {
        return this.chemObjectReader.accepts(classObject);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove entries with the RandomAccessSDFReader");
    }
}

