/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.similarity;

import java.util.BitSet;
import java.util.Map;
import java.util.TreeSet;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IntArrayFingerprint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.similarity.TanimotoTest")
public class Tanimoto {
    private Tanimoto() {
    }

    @TestMethod(value="testTanimoto1,testTanimoto2")
    public static float calculate(BitSet bitset1, BitSet bitset2) throws CDKException {
        float _bitset1_cardinality = bitset1.cardinality();
        float _bitset2_cardinality = bitset2.cardinality();
        if (bitset1.size() != bitset2.size()) {
            throw new CDKException("Bitsets must have the same bit length");
        }
        BitSet one_and_two = (BitSet)bitset1.clone();
        one_and_two.and(bitset2);
        float _common_bit_count = one_and_two.cardinality();
        return _common_bit_count / (_bitset1_cardinality + _bitset2_cardinality - _common_bit_count);
    }

    @TestMethod(value="testCalculate_BitFingerprint")
    public static double calculate(IBitFingerprint fingerprint1, IBitFingerprint fingerprint2) {
        if (fingerprint1.size() != fingerprint2.size()) {
            throw new IllegalArgumentException("Fingerprints must have the same size");
        }
        int cardinality1 = fingerprint1.cardinality();
        int cardinality2 = fingerprint2.cardinality();
        IBitFingerprint one_and_two = fingerprint1 instanceof IntArrayFingerprint ? new IntArrayFingerprint(fingerprint1) : new BitSetFingerprint(fingerprint1);
        one_and_two.and(fingerprint2);
        double cardinalityCommon = one_and_two.cardinality();
        return cardinalityCommon / ((double)(cardinality1 + cardinality2) - cardinalityCommon);
    }

    @TestMethod(value="testTanimoto3")
    public static float calculate(double[] features1, double[] features2) throws CDKException {
        if (features1.length != features2.length) {
            throw new CDKException("Features vectors must be of the same length");
        }
        int n = features1.length;
        double ab = 0.0;
        double a2 = 0.0;
        double b2 = 0.0;
        for (int i = 0; i < n; ++i) {
            ab += features1[i] * features2[i];
            a2 += features1[i] * features1[i];
            b2 += features2[i] * features2[i];
        }
        return (float)ab / (float)(a2 + b2 - ab);
    }

    @TestMethod(value="testTanimoto4")
    public static float calculate(Map<String, Integer> features1, Map<String, Integer> features2) {
        TreeSet<String> common = new TreeSet<String>(features1.keySet());
        common.retainAll(features2.keySet());
        double xy = 0.0;
        double x = 0.0;
        double y = 0.0;
        for (String s : common) {
            int c1 = features1.get(s);
            int c2 = features2.get(s);
            xy += (double)(c1 * c2);
        }
        for (Integer c : features1.values()) {
            x += (double)(c * c);
        }
        for (Integer c : features2.values()) {
            y += (double)(c * c);
        }
        return (float)(xy / (x + y - xy));
    }

    @TestMethod(value="testICountFingerprintComparison")
    public static double calculate(ICountFingerprint fp1, ICountFingerprint fp2) {
        long xy = 0L;
        long x = 0L;
        long y = 0L;
        for (int i = 0; i < fp1.numOfPopulatedbins(); ++i) {
            int hash = fp1.getHash(i);
            for (int j = 0; j < fp2.numOfPopulatedbins(); ++j) {
                if (hash != fp2.getHash(j)) continue;
                xy += (long)(fp1.getCount(i) * fp2.getCount(j));
            }
            x += (long)(fp1.getCount(i) * fp1.getCount(i));
        }
        for (int j = 0; j < fp2.numOfPopulatedbins(); ++j) {
            y += (long)(fp2.getCount(j) * fp2.getCount(j));
        }
        return (double)xy / (double)(x + y - xy);
    }

    @TestMethod(value="method1")
    public static double method1(ICountFingerprint fp1, ICountFingerprint fp2) {
        return Tanimoto.calculate(fp1, fp2);
    }

    @TestMethod(value="method2")
    public static double method2(ICountFingerprint fp1, ICountFingerprint fp2) {
        long maxSum = 0L;
        long minSum = 0L;
        int i = 0;
        int j = 0;
        while (i < fp1.numOfPopulatedbins() || j < fp2.numOfPopulatedbins()) {
            Integer count2;
            Integer hash1 = i < fp1.numOfPopulatedbins() ? Integer.valueOf(fp1.getHash(i)) : null;
            Integer hash2 = j < fp2.numOfPopulatedbins() ? Integer.valueOf(fp2.getHash(j)) : null;
            Integer count1 = i < fp1.numOfPopulatedbins() ? Integer.valueOf(fp1.getCount(i)) : null;
            Integer n = count2 = j < fp2.numOfPopulatedbins() ? Integer.valueOf(fp2.getCount(j)) : null;
            if (count2 == null || hash1 != null && hash1 < hash2) {
                maxSum += (long)count1.intValue();
                ++i;
                continue;
            }
            if (count1 == null || hash2 != null && hash1 > hash2) {
                maxSum += (long)count2.intValue();
                ++j;
                continue;
            }
            if (!hash1.equals(hash2)) continue;
            maxSum += (long)Math.max(count1, count2);
            minSum += (long)Math.min(count1, count2);
            ++i;
            ++j;
        }
        return (double)minSum / (double)maxSum;
    }
}

