/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fragment.MurckoFragmenter;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.DoubleResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public class FMFDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    @Override
    public DescriptorValue calculate(IAtomContainer container) {
        DoubleResult result;
        MurckoFragmenter fragmenter = new MurckoFragmenter(true, 3);
        try {
            fragmenter.generateFragments(container);
            IAtomContainer[] framework = fragmenter.getFrameworksAsContainers();
            IAtomContainer[] ringSystems = fragmenter.getRingSystemsAsContainers();
            result = framework.length == 1 ? new DoubleResult((double)framework[0].getAtomCount() / (double)container.getAtomCount()) : (framework.length == 0 && ringSystems.length == 1 ? new DoubleResult((double)ringSystems[0].getAtomCount() / (double)container.getAtomCount()) : new DoubleResult(0.0));
        }
        catch (CDKException e) {
            result = new DoubleResult(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResultType();
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#fmf", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return new String[]{"FMF"};
    }
}

