/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash.stereo;

import javax.vecmath.Point2d;
import org.openscience.cdk.hash.stereo.GeometricParity;

final class DoubleBond2DParity
extends GeometricParity {
    private Point2d l;
    private Point2d r;
    private Point2d l1;
    private Point2d r1;
    private Point2d l2;
    private Point2d r2;
    private static final double THRESHOLD = 0.1;

    public DoubleBond2DParity(Point2d left, Point2d right, Point2d leftSubstituent, Point2d rightSubstituent) {
        this.l = left;
        this.r = right;
        this.l1 = leftSubstituent;
        this.r1 = rightSubstituent;
        this.l2 = this.l;
        this.r2 = this.r;
    }

    public DoubleBond2DParity(Point2d left, Point2d right, Point2d leftSubstituent1, Point2d leftSubstituent2, Point2d rightSubstituent1, Point2d rightSubstituent2) {
        this.l = left;
        this.r = right;
        this.l1 = leftSubstituent1;
        this.r1 = rightSubstituent1;
        this.l2 = leftSubstituent2;
        this.r2 = rightSubstituent2;
    }

    @Override
    public int parity() {
        return DoubleBond2DParity.parity(this.l1, this.l2, this.r) * DoubleBond2DParity.parity(this.r1, this.r2, this.l);
    }

    private static int parity(Point2d a, Point2d b, Point2d c) {
        double det = (a.x - c.x) * (b.y - c.y) - (a.y - c.y) * (b.x - c.x);
        return Math.abs(det) < 0.1 ? 0 : (int)Math.signum(det);
    }
}

