/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.SQLCache;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.FilterIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultSetIterator<T>
implements ExtendedIterator<T> {
    protected ResultSet m_resultSet;
    protected SQLCache m_sqlCache;
    protected PreparedStatement m_statement;
    protected boolean m_statementClean = true;
    protected String m_opname;
    protected T m_row;
    protected int m_nCols;
    protected boolean m_finished = false;
    protected boolean m_prefetched = false;
    private static Logger logger = LoggerFactory.getLogger(ResultSetIterator.class);

    public ResultSetIterator() {
        this.m_finished = true;
    }

    public ResultSetIterator(ResultSet resultSet, PreparedStatement sourceStatement, SQLCache cache, String opname) {
        this.m_resultSet = resultSet;
        this.m_sqlCache = cache;
        this.m_statement = sourceStatement;
        this.m_opname = opname;
    }

    public ResultSetIterator(ResultSet resultSet, PreparedStatement sourceStatement) {
        this.m_resultSet = resultSet;
        this.m_statement = sourceStatement;
    }

    public void reset(ResultSet resultSet, PreparedStatement sourceStatement, SQLCache cache, String opname) {
        this.m_resultSet = resultSet;
        this.m_sqlCache = cache;
        this.m_statement = sourceStatement;
        this.m_opname = opname;
        this.m_finished = false;
        this.m_prefetched = false;
        this.m_row = null;
        this.m_statementClean = true;
    }

    public void reset(ResultSet resultSet, PreparedStatement sourceStatement) {
        this.m_resultSet = resultSet;
        this.m_sqlCache = null;
        this.m_statement = sourceStatement;
        this.m_opname = null;
        this.m_finished = false;
        this.m_prefetched = false;
        this.m_row = null;
        this.m_statementClean = false;
    }

    @Override
    public boolean hasNext() {
        if (!this.m_finished && !this.m_prefetched) {
            this.moveForward();
        }
        return !this.m_finished;
    }

    @Override
    public T removeNext() {
        this.cantRemove();
        return null;
    }

    @Override
    public T next() {
        if (!this.m_finished && !this.m_prefetched) {
            this.moveForward();
        }
        this.m_prefetched = false;
        if (this.m_finished) {
            throw new NoSuchElementException();
        }
        return this.getRow();
    }

    @Override
    public void remove() {
        this.cantRemove();
    }

    protected void cantRemove() {
        throw new UnsupportedOperationException("ResultSetIterator can't remove database rows");
    }

    protected void moveForward() {
        try {
            if (!this.m_finished && this.m_resultSet.next()) {
                this.extractRow();
                this.m_prefetched = true;
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            logger.warn("Problem in iterator over db result set, op = " + this.m_opname, e);
            throw new JenaException(e);
        }
    }

    protected abstract void extractRow() throws Exception;

    protected T getRow() {
        return this.m_row;
    }

    @Override
    public void close() {
        if (!this.m_finished) {
            if (this.m_resultSet != null) {
                try {
                    this.m_resultSet.close();
                    this.m_resultSet = null;
                }
                catch (SQLException e) {
                    logger.warn("Error while finalizing result set iterator", e);
                }
            }
            if (this.m_statementClean) {
                if (this.m_sqlCache != null && this.m_opname != null) {
                    this.m_sqlCache.returnPreparedSQLStatement(this.m_statement);
                } else {
                    try {
                        this.m_statement.close();
                    }
                    catch (SQLException e) {
                        logger.warn("Error while finalizing result set iterator", e);
                    }
                }
            }
        }
        this.m_finished = true;
    }

    public Object getSingleton() throws SQLException {
        List row = (List)this.next();
        this.close();
        return row.get(0);
    }

    protected void finalize() throws SQLException {
        if (!this.m_finished && this.m_resultSet != null) {
            this.close();
        }
    }

    @Override
    public <X extends T> ExtendedIterator<T> andThen(Iterator<X> other) {
        return NiceIterator.andThen(this, other);
    }

    @Override
    public Set<T> toSet() {
        return NiceIterator.asSet(this);
    }

    @Override
    public List<T> toList() {
        return NiceIterator.asList(this);
    }

    @Override
    public ExtendedIterator<T> filterKeep(Filter<T> f) {
        return new FilterIterator<T>(f, this);
    }

    @Override
    public ExtendedIterator<T> filterDrop(final Filter<T> f) {
        Filter notF = new Filter<T>(){

            @Override
            public boolean accept(T x) {
                return !f.accept(x);
            }
        };
        return new FilterIterator(notF, this);
    }

    @Override
    public <X> ExtendedIterator<X> mapWith(Map1<T, X> map1) {
        return new Map1Iterator<T, X>(map1, this);
    }
}

