/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.bond;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.qsar.AbstractBondDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.DoubleResult;

@TestClass(value="org.openscience.cdk.qsar.descriptors.bond.BondPartialSigmaChargeDescriptorTest")
public class BondPartialSigmaChargeDescriptor
extends AbstractBondDescriptor {
    private GasteigerMarsiliPartialCharges peoe = new GasteigerMarsiliPartialCharges();
    private int maxIterations;
    private static final String[] descriptorNames = new String[]{"peoeB"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#bondPartialSigmaCharge", this.getClass().getName(), "$Id: f7eea315e39113ce1e4bed313ad40f9fdcc9d012 $", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("PartialSigmaChargeDescriptor only expects one parameter");
        }
        if (!(params[0] instanceof Integer)) {
            throw new CDKException("The parameter 1 must be of type Integer");
        }
        this.maxIterations = (Integer)params[0];
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.maxIterations};
        return params;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return descriptorNames;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), descriptorNames, e);
    }

    @Override
    @TestMethod(value="testCalculate_IBond_IAtomContainer,testBondSigmaElectronegativityDescriptor,testBondSigmaElectronegativityDescriptor_Methyl_chloride")
    public DescriptorValue calculate(IBond bond, IAtomContainer ac) {
        Double originalCharge1 = bond.getAtom(0).getCharge();
        Double originalCharge2 = bond.getAtom(1).getCharge();
        if (!this.isCachedAtomContainer(ac)) {
            IMolecule mol = ac.getBuilder().newInstance(IMolecule.class, ac);
            if (this.maxIterations != 0) {
                this.peoe.setMaxGasteigerIters(this.maxIterations);
            }
            try {
                this.peoe.assignGasteigerMarsiliSigmaPartialCharges(mol, true);
                for (IBond bondi : ac.bonds()) {
                    double result = Math.abs(bondi.getAtom(0).getCharge() - bondi.getAtom(1).getCharge());
                    this.cacheDescriptorValue(bondi, ac, new DoubleResult(result));
                }
            }
            catch (Exception ex1) {
                return this.getDummyDescriptorValue(ex1);
            }
        }
        bond.getAtom(0).setCharge(originalCharge1);
        bond.getAtom(1).setCharge(originalCharge2);
        return this.getCachedDescriptorValue(bond) != null ? new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), this.getCachedDescriptorValue(bond), descriptorNames) : null;
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"maxIterations"};
        return params;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        if ("maxIterations".equals(name)) {
            return Integer.MAX_VALUE;
        }
        return null;
    }
}

