/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.selection;

import java.util.Collection;
import java.util.HashSet;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.renderer.selection.IChemObjectSelection;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class LinkedSelection
implements IChemObjectSelection {
    IChemObject start;
    IAtomContainer selected;

    public LinkedSelection(IChemObject selected) {
        this.start = selected;
    }

    @Override
    public boolean contains(IChemObject obj) {
        if (this.selected == null) {
            return false;
        }
        if (obj instanceof IAtom) {
            return this.selected.contains((IAtom)obj);
        }
        if (obj instanceof IBond) {
            return this.selected.contains((IBond)obj);
        }
        return false;
    }

    @Override
    public <E extends IChemObject> Collection<E> elements(Class<E> clazz) {
        HashSet<Object> set = new HashSet<Object>();
        if (clazz.isAssignableFrom(IAtom.class)) {
            for (IAtom atom : this.selected.atoms()) {
                set.add(atom);
            }
        }
        if (clazz.isAssignableFrom(IBond.class)) {
            for (IBond bond : this.selected.bonds()) {
                set.add(bond);
            }
        }
        return set;
    }

    @Override
    public IAtomContainer getConnectedAtomContainer() {
        return (IAtomContainer)this.selected.getBuilder().newInstance(IAtomContainer.class, new Object[]{this.selected});
    }

    @Override
    public boolean isFilled() {
        return this.selected != null && this.selected.getAtomCount() != 0;
    }

    @Override
    public void select(IChemModel chemModel) {
        if (this.start instanceof IAtom) {
            IAtom atom = (IAtom)this.start;
            IAtomContainer container = ChemModelManipulator.getRelevantAtomContainer((IChemModel)chemModel, (IAtom)atom);
            IChemModel parts = this.getParts(container);
            this.selected = ChemModelManipulator.getRelevantAtomContainer((IChemModel)parts, (IAtom)atom);
        } else if (this.start instanceof IBond) {
            IBond bond = (IBond)this.start;
            IAtomContainer container = ChemModelManipulator.getRelevantAtomContainer((IChemModel)chemModel, (IBond)bond);
            IChemModel parts = this.getParts(container);
            this.selected = ChemModelManipulator.getRelevantAtomContainer((IChemModel)parts, (IBond)bond);
        } else if (this.start instanceof IAtomContainer) {
            IAtomContainer result = (IAtomContainer)chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            IAtomContainer container = chemModel.getMoleculeSet().getAtomContainer(0);
            IChemModel parts = this.getParts(container);
            for (IAtom atom : ((IAtomContainer)this.start).atoms()) {
                result.add(ChemModelManipulator.getRelevantAtomContainer((IChemModel)parts, (IAtom)atom));
            }
            this.selected = result;
        }
    }

    private IChemModel getParts(IAtomContainer container) {
        IMoleculeSet molecules = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)container);
        IChemModel parts = (IChemModel)container.getBuilder().newInstance(IChemModel.class, new Object[0]);
        parts.setMoleculeSet(molecules);
        return parts;
    }
}

