/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.deploy.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import net.sf.jnati.FileUtils;
import net.sf.jnati.deploy.artefact.Artefact;
import net.sf.jnati.deploy.repository.ArtefactRepository;
import net.sf.jnati.deploy.source.ArtefactSource;
import net.sf.jnati.deploy.source.TempJarSource;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteRepository
extends ArtefactRepository {
    private static final Logger LOG = Logger.getLogger(RemoteRepository.class);
    private static final String FS = "/";
    private static final String S = "-";
    private static final String EXT = ".jar";
    private final URL root;

    public RemoteRepository(URL root) {
        this.root = root;
    }

    private URL getUrl(Artefact artefact) throws MalformedURLException {
        String path = artefact.getId() + FS + artefact.getVersion() + FS + artefact.getId() + S + artefact.getVersion() + S + artefact.getOsArch() + EXT;
        return new URL(this.root.toString() + FS + path);
    }

    @Override
    public List<? extends ArtefactSource> getArtefactSource(Artefact artefact) throws IOException {
        InputStream in;
        LOG.info("Searching remote repository for: " + artefact + " (" + this.root + ")");
        URL url = this.getUrl(artefact);
        File tempFile = File.createTempFile("jnati", EXT);
        try {
            in = url.openStream();
        }
        catch (FileNotFoundException e) {
            LOG.debug("Not found: " + url);
            return null;
        }
        LOG.debug("Downloading artefact: " + url);
        FileUtils.writeStreamToFile(in, tempFile);
        LOG.debug("Download complete: " + tempFile);
        return Collections.singletonList(new TempJarSource(tempFile, artefact));
    }
}

