/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.signature;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.signature.AtomSignature;
import org.openscience.cdk.signature.MoleculeFromSignatureBuilder;
import org.openscience.cdk.signature.Orbit;
import signature.AbstractGraphSignature;
import signature.AbstractVertexSignature;
import signature.ColoredTree;
import signature.SymmetryClass;

@TestClass(value="org.openscience.cdk.signature.MoleculeSignatureTest")
public class MoleculeSignature
extends AbstractGraphSignature {
    private IAtomContainer molecule;

    public MoleculeSignature(IAtomContainer molecule) {
        this.molecule = molecule;
    }

    public MoleculeSignature(IMolecule molecule, int height) {
        super(height);
        this.molecule = molecule;
    }

    @Override
    @TestMethod(value="getVertexCountTest")
    protected int getVertexCount() {
        return this.molecule.getAtomCount();
    }

    @Override
    @TestMethod(value="getSignatureStringForVertexTest")
    public String signatureStringForVertex(int vertexIndex) {
        int height = super.getHeight();
        AtomSignature atomSignature = height == -1 ? new AtomSignature(vertexIndex, this.molecule) : new AtomSignature(vertexIndex, height, this.molecule);
        return atomSignature.toCanonicalString();
    }

    @Override
    @TestMethod(value="getSignatureStringForVertexTest_height")
    public String signatureStringForVertex(int vertexIndex, int height) {
        AtomSignature atomSignature = new AtomSignature(vertexIndex, height, this.molecule);
        return atomSignature.toCanonicalString();
    }

    @Override
    @TestMethod(value="getSignatureForVertexTest")
    public AbstractVertexSignature signatureForVertex(int vertexIndex) {
        return new AtomSignature(vertexIndex, this.molecule);
    }

    @TestMethod(value="calculateOrbitsTest")
    public List<Orbit> calculateOrbits() {
        ArrayList<Orbit> orbits = new ArrayList<Orbit>();
        List<SymmetryClass> symmetryClasses = super.getSymmetryClasses();
        for (SymmetryClass symmetryClass : symmetryClasses) {
            Orbit orbit = new Orbit(symmetryClass.getSignatureString(), -1);
            for (int atomIndex : symmetryClass) {
                orbit.addAtom(atomIndex);
            }
            orbits.add(orbit);
        }
        return orbits;
    }

    @TestMethod(value="fromSignatureStringTest")
    public static IAtomContainer fromSignatureString(String signatureString, IChemObjectBuilder coBuilder) {
        ColoredTree tree = AtomSignature.parse(signatureString);
        MoleculeFromSignatureBuilder builder = new MoleculeFromSignatureBuilder(coBuilder);
        builder.makeFromColoredTree(tree);
        return builder.getAtomContainer();
    }

    @TestMethod(value="toCanonicalSignatureStringTest")
    public String toCanonicalSignatureString(int height) {
        String canonicalSignature = null;
        for (int i = 0; i < this.getVertexCount(); ++i) {
            String signatureForI = this.signatureStringForVertex(i, height);
            if (canonicalSignature != null && canonicalSignature.compareTo(signatureForI) >= 0) continue;
            canonicalSignature = signatureForI;
        }
        return canonicalSignature;
    }
}

