/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;

@TestClass(value="org.openscience.cdk.io.formats.MoSSOutputFormatTest")
public class MoSSOutputFormat
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    private MoSSOutputFormat() {
    }

    @TestMethod(value="testResourceFormatSet")
    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new MoSSOutputFormat();
        }
        return myself;
    }

    @Override
    @TestMethod(value="testGetFormatName")
    public String getFormatName() {
        return "MoSS Output Format";
    }

    @Override
    @TestMethod(value="testGetMIMEType")
    public String getMIMEType() {
        return "text/csv";
    }

    @Override
    @TestMethod(value="testGetPreferredNameExtension")
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @Override
    @TestMethod(value="testGetNameExtensions")
    public String[] getNameExtensions() {
        return new String[]{"mossoutput"};
    }

    @Override
    @TestMethod(value="testGetReaderClassName")
    public String getReaderClassName() {
        return null;
    }

    @Override
    @TestMethod(value="testGetWriterClassName")
    public String getWriterClassName() {
        return null;
    }

    @Override
    public boolean matches(int lineNumber, String line) {
        return lineNumber == 1 && line.equals("id,description,nodes,edges,s_abs,s_rel,c_abs,c_rel");
    }

    @Override
    @TestMethod(value="testIsXMLBased")
    public boolean isXMLBased() {
        return false;
    }

    @Override
    @TestMethod(value="testGetSupportedDataFeatures")
    public int getSupportedDataFeatures() {
        return 512;
    }

    @Override
    @TestMethod(value="testGetRequiredDataFeatures")
    public int getRequiredDataFeatures() {
        return 512;
    }
}

