/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import java.util.List;
import java.util.Map;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.isomorphism.mcss.RMap;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class AtomMappingTools {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(AtomMappingTools.class);

    public static Map<Integer, Integer> mapAtomsOfAlignedStructures(IAtomContainer firstAtomContainer, IAtomContainer secondAtomContainer, Map<Integer, Integer> mappedAtoms) throws CDKException {
        if (firstAtomContainer.getAtomCount() < 1 & secondAtomContainer.getAtomCount() < 1) {
            return mappedAtoms;
        }
        try {
            List<RMap> list = UniversalIsomorphismTester.getSubgraphAtomsMap(firstAtomContainer, secondAtomContainer);
            for (int i = 0; i < list.size(); ++i) {
                RMap map = list.get(i);
                IAtom atom1 = firstAtomContainer.getAtom(map.getId1());
                IAtom atom2 = secondAtomContainer.getAtom(map.getId2());
                if (AtomMappingTools.checkAtomMapping(firstAtomContainer, secondAtomContainer, firstAtomContainer.getAtomNumber(atom1), secondAtomContainer.getAtomNumber(atom2))) {
                    mappedAtoms.put(firstAtomContainer.getAtomNumber(atom1), secondAtomContainer.getAtomNumber(atom2));
                    continue;
                }
                logger.error("Error: Atoms are not similar !!");
            }
        }
        catch (CDKException e) {
            throw new CDKException("Error in UniversalIsomorphismTester due to:" + e.toString(), e);
        }
        return mappedAtoms;
    }

    private static boolean checkAtomMapping(IAtomContainer firstAC, IAtomContainer secondAC, int posFirstAtom, int posSecondAtom) {
        IAtom firstAtom = firstAC.getAtom(posFirstAtom);
        IAtom secondAtom = secondAC.getAtom(posSecondAtom);
        return firstAtom.getSymbol().equals(secondAtom.getSymbol()) && firstAC.getConnectedAtomsList(firstAtom).size() == secondAC.getConnectedAtomsList(secondAtom).size() && firstAtom.getBondOrderSum() == secondAtom.getBondOrderSum() && firstAtom.getMaxBondOrder() == secondAtom.getMaxBondOrder();
    }
}

