/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class MonitorInputStream
extends FilterInputStream {
    int length;
    int position;
    int markPosition;
    int readEventCount;
    long timeBegin;

    MonitorInputStream(InputStream in, int length) {
        super(in);
        this.length = length;
        this.position = 0;
        this.timeBegin = System.currentTimeMillis();
    }

    public int read() throws IOException {
        ++this.readEventCount;
        int nextByte = super.read();
        if (nextByte >= 0) {
            ++this.position;
        }
        return nextByte;
    }

    public int read(byte[] b) throws IOException {
        ++this.readEventCount;
        int cb = super.read(b);
        if (cb > 0) {
            this.position += cb;
        }
        return cb;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        ++this.readEventCount;
        int cb = super.read(b, off, len);
        if (cb > 0) {
            this.position += cb;
        }
        return cb;
    }

    public long skip(long n) throws IOException {
        long cb = super.skip(n);
        this.position = (int)((long)this.position + cb);
        return cb;
    }

    public void mark(int readlimit) {
        super.mark(readlimit);
        this.markPosition = this.position;
    }

    public void reset() throws IOException {
        this.position = this.markPosition;
        super.reset();
    }

    int getPosition() {
        return this.position;
    }

    int getLength() {
        return this.length;
    }

    int getPercentageRead() {
        return this.position * 100 / this.length;
    }

    int getReadingTimeMillis() {
        return (int)(System.currentTimeMillis() - this.timeBegin);
    }
}

