/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Mesh;
import org.jmol.viewer.MeshCollection;

class Draw
extends MeshCollection {
    static final int MAX_POINTS = 256;
    Point3f[] ptList = new Point3f[256];
    int[] ptIdentifiers = new int[256];
    boolean[] reversePoints = new boolean[256];
    boolean[] useVertices = new boolean[256];
    BitSet[] ptBitSets = new BitSet[256];
    BitSet bsAllAtoms = new BitSet();
    Vector3f offset = new Vector3f();
    Point3f xyz = new Point3f();
    int ipt;
    int nPoints;
    int nbitsets;
    int ncoord;
    int nidentifiers;
    float newScale;
    float length;
    boolean isCurve;
    boolean isArrow;
    boolean isCircle;
    boolean isFixed;
    boolean isVisible;
    boolean isPerpendicular;
    boolean isVertices;
    boolean isPlane;
    boolean isReversed;
    boolean isRotated45;
    boolean isCrossed;
    boolean isValid;
    final Vector3f vAB = new Vector3f();
    final Vector3f vAC = new Vector3f();
    static final int MAX_OBJECT_CLICK_DISTANCE_SQUARED = 100;
    Mesh pickedMesh = null;
    int pickedModel;
    int pickedVertex;
    final Point3i ptXY = new Point3i();

    Draw() {
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        Logger.debug("draw " + propertyName + " " + value);
        if ("init" == propertyName) {
            this.nPoints = -1;
            this.nidentifiers = 0;
            this.nbitsets = 0;
            this.ncoord = 0;
            this.ipt = 0;
            this.isCrossed = false;
            this.isRotated45 = false;
            this.isReversed = false;
            this.isFixed = false;
            this.isPerpendicular = false;
            this.isVertices = false;
            this.isPlane = false;
            this.isArrow = false;
            this.isCurve = false;
            this.isValid = true;
            this.isVisible = true;
            this.length = Float.MAX_VALUE;
            this.offset = new Vector3f();
            super.setProperty("thisID", null, null);
            return;
        }
        if ("length" == propertyName) {
            this.length = ((Float)value).floatValue();
            return;
        }
        if ("fixed" == propertyName) {
            this.isFixed = (Boolean)value;
            return;
        }
        if ("perp" == propertyName) {
            this.isPerpendicular = true;
            return;
        }
        if ("plane" == propertyName) {
            this.isPlane = true;
            return;
        }
        if ("curve" == propertyName) {
            this.isCurve = true;
            return;
        }
        if ("arrow" == propertyName) {
            this.isArrow = true;
            return;
        }
        if ("vertices" == propertyName) {
            this.isVertices = true;
            return;
        }
        if ("reverse" == propertyName) {
            this.isReversed = true;
            return;
        }
        if ("rotate45" == propertyName) {
            this.isRotated45 = true;
            return;
        }
        if ("crossed" == propertyName) {
            this.isCrossed = true;
            return;
        }
        if ("points" == propertyName) {
            this.nPoints = 0;
            this.newScale = ((Integer)value).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 1.0f;
            }
            return;
        }
        if ("scale" == propertyName) {
            this.newScale = ((Integer)value).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 0.01f;
            }
            if (this.currentMesh != null) {
                this.scaleDrawing(this.currentMesh, this.newScale);
                this.currentMesh.initialize();
            }
            return;
        }
        if ("identifier" == propertyName) {
            String thisID = (String)value;
            int meshIndex = this.getIndexFromName(thisID);
            if (meshIndex >= 0) {
                this.reversePoints[this.nidentifiers] = this.isReversed;
                this.useVertices[this.nidentifiers] = this.isVertices;
                this.ptIdentifiers[this.nidentifiers] = meshIndex;
                ++this.nidentifiers;
                ++this.nPoints;
                this.isVertices = false;
                this.isReversed = false;
            } else {
                Logger.error("draw identifier " + value + " not found");
                this.isValid = false;
            }
            return;
        }
        if ("coord" == propertyName) {
            if (this.ncoord == 256) {
                return;
            }
            this.ptList[this.ncoord++] = new Point3f((Point3f)value);
            ++this.nPoints;
            return;
        }
        if ("offset" == propertyName) {
            this.offset = new Vector3f((Point3f)value);
            return;
        }
        if ("atomSet" == propertyName) {
            if (this.viewer.cardinalityOf((BitSet)value) == 0) {
                return;
            }
            this.ptBitSets[this.nbitsets++] = (BitSet)value;
            this.bsAllAtoms.or((BitSet)value);
            ++this.nPoints;
            return;
        }
        if ("set" == propertyName) {
            if (this.currentMesh == null) {
                this.allocMesh(null);
            }
            boolean bl = this.currentMesh.isValid = this.isValid ? this.setDrawing() : false;
            if (this.currentMesh.isValid) {
                this.scaleDrawing(this.currentMesh, this.newScale);
                this.currentMesh.initialize();
                this.currentMesh.setAxes();
                this.currentMesh.drawOffset = this.offset;
                this.currentMesh.visible = this.isVisible;
            }
            this.nPoints = -1;
            return;
        }
        if ("off" == propertyName) {
            this.isVisible = false;
        }
        super.setProperty(propertyName, value, bs);
    }

    Object getProperty(String property, int index) {
        if (property == "command") {
            return this.getDrawCommand(this.currentMesh);
        }
        return super.getProperty(property, index);
    }

    boolean setDrawing() {
        if (this.currentMesh == null) {
            this.allocMesh(null);
        }
        this.currentMesh.clear("draw");
        if (this.nPoints == 0) {
            return false;
        }
        int nPoly = 0;
        int modelCount = this.viewer.getModelCount();
        if (this.isFixed) {
            this.currentMesh.setPolygonCount(1);
            this.currentMesh.ptCenters = null;
            this.currentMesh.modelFlags = null;
            this.addModelPoints(-1);
            nPoly = this.setPolygons(nPoly);
        } else {
            BitSet bsAllModels = new BitSet();
            bsAllModels = this.nbitsets > 0 ? this.viewer.getModelBitSet(this.bsAllAtoms) : this.viewer.getVisibleFramesBitSet();
            this.currentMesh.setPolygonCount(modelCount);
            this.currentMesh.ptCenters = new Point3f[modelCount];
            this.currentMesh.modelFlags = new int[modelCount];
            for (int iModel = 0; iModel < modelCount; ++iModel) {
                if (!bsAllModels.get(iModel)) continue;
                this.addModelPoints(iModel);
                nPoly = this.setPolygons(nPoly);
                this.currentMesh.setCenter(iModel);
            }
        }
        this.currentMesh.setCenter(-1);
        return true;
    }

    void addPoint(Point3f newPt) {
        this.ptList[this.nPoints++] = new Point3f(newPt);
        if (this.nPoints > 256) {
            this.nPoints = 256;
        }
    }

    private void addModelPoints(int iModel) {
        this.nPoints = this.ncoord;
        for (int i = 0; i < this.nidentifiers; ++i) {
            Mesh m = this.meshes[this.ptIdentifiers[i]];
            if (this.isPlane || this.isPerpendicular || this.useVertices[i]) {
                if (this.reversePoints[i]) {
                    this.ipt = m.drawVertexCount;
                    while (--this.ipt >= 0) {
                        this.addPoint(m.vertices[this.ipt]);
                    }
                    continue;
                }
                this.ipt = 0;
                while (this.ipt < m.drawVertexCount) {
                    this.addPoint(m.vertices[this.ipt]);
                    ++this.ipt;
                }
                continue;
            }
            if (iModel < 0 || m.ptCenters == null || m.ptCenters[iModel] == null) {
                this.addPoint(m.ptCenter);
                continue;
            }
            this.addPoint(m.ptCenters[iModel]);
        }
        if (iModel < 0) {
            return;
        }
        BitSet bsModel = this.viewer.getModelAtomBitSet(iModel);
        for (int i = 0; i < this.nbitsets; ++i) {
            BitSet bs = (BitSet)this.ptBitSets[i].clone();
            bs.and(bsModel);
            if (this.viewer.cardinalityOf(bs) <= 0) continue;
            this.addPoint(this.viewer.getAtomSetCenter(bs));
        }
    }

    private int setPolygons(int nPoly) {
        if (this.nPoints == 4 && this.isCrossed) {
            Point3f pt = new Point3f(this.ptList[1]);
            this.ptList[1].set(this.ptList[2]);
            this.ptList[2].set(pt);
        }
        return this.setPolygon(this.currentMesh, this.nPoints, nPoly);
    }

    private int setPolygon(Mesh mesh, int nVertices, int nPoly) {
        int drawType = 6;
        if ((this.isCurve || this.isArrow || this.isCircle) && nVertices >= 2) {
            int n = this.isCurve ? 3 : (drawType = this.isArrow ? 1 : 2);
        }
        if (drawType == 6) {
            float dist;
            Point3f pt;
            Point3f center = new Point3f();
            Vector3f normal = new Vector3f();
            if (nVertices == 3 && this.isPlane && !this.isPerpendicular) {
                pt = new Point3f(this.ptList[1]);
                pt.sub(this.ptList[0]);
                pt.scale(0.5f);
                this.ptList[3] = new Point3f(this.ptList[2]);
                this.ptList[2].add(pt);
                this.ptList[3].sub(pt);
                nVertices = 4;
            } else if (nVertices >= 3 && !this.isPlane && this.isPerpendicular) {
                Graphics3D.calcNormalizedNormal(this.ptList[0], this.ptList[1], this.ptList[2], normal, this.vAB, this.vAC);
                center = new Point3f(this.ptList[0]);
                for (int i = 1; i < nVertices; ++i) {
                    center.add(this.ptList[i]);
                }
                center.scale(1.0f / (float)nVertices);
                dist = this.length == Float.MAX_VALUE ? this.ptList[0].distance(center) : this.length;
                normal.scale(dist);
                this.ptList[0].set(center);
                this.ptList[1].set(center);
                this.ptList[1].add(normal);
                nVertices = 2;
            } else if (nVertices == 2 && this.isPerpendicular) {
                this.g3d.calcAveragePoint(this.ptList[0], this.ptList[1], center);
                float f = dist = this.length == Float.MAX_VALUE ? this.ptList[0].distance(center) : this.length;
                if (this.isPlane && this.length != Float.MAX_VALUE) {
                    dist /= 2.0f;
                }
                if (this.isPlane && this.isRotated45) {
                    dist *= 1.4142f;
                }
                this.g3d.calcXYNormalToLine(this.ptList[0], this.ptList[1], normal);
                normal.scale(dist);
                if (this.isPlane) {
                    this.ptList[2] = new Point3f(center);
                    this.ptList[2].sub(normal);
                    pt = new Point3f(center);
                    pt.add(normal);
                    Graphics3D.calcNormalizedNormal(this.ptList[0], this.ptList[1], this.ptList[2], normal, this.vAB, this.vAC);
                    normal.scale(dist);
                    this.ptList[3] = new Point3f(center);
                    this.ptList[3].add(normal);
                    this.ptList[1].set(center);
                    this.ptList[1].sub(normal);
                    this.ptList[0].set(pt);
                    if (this.isRotated45) {
                        this.g3d.calcAveragePoint(this.ptList[0], this.ptList[1], this.ptList[0]);
                        this.g3d.calcAveragePoint(this.ptList[1], this.ptList[2], this.ptList[1]);
                        this.g3d.calcAveragePoint(this.ptList[2], this.ptList[3], this.ptList[2]);
                        this.g3d.calcAveragePoint(this.ptList[3], pt, this.ptList[3]);
                    }
                    nVertices = 4;
                } else {
                    this.ptList[0].set(center);
                    this.ptList[1].set(center);
                    this.ptList[0].sub(normal);
                    this.ptList[1].add(normal);
                }
            } else if (nVertices == 2 && this.length != Float.MAX_VALUE) {
                this.g3d.calcAveragePoint(this.ptList[0], this.ptList[1], center);
                normal.set(this.ptList[1]);
                normal.sub(center);
                normal.scale(0.5f / normal.length() * this.length);
                this.ptList[0].set(center);
                this.ptList[1].set(center);
                this.ptList[0].sub(normal);
                this.ptList[1].add(normal);
            }
            if (nVertices > 4) {
                nVertices = 4;
            }
            switch (nVertices) {
                case 1: {
                    break;
                }
                case 2: {
                    drawType = 4;
                    break;
                }
                default: {
                    drawType = 5;
                }
            }
        }
        mesh.drawType = drawType;
        mesh.drawVertexCount = nVertices;
        if (nVertices == 0) {
            return nPoly;
        }
        int nVertices0 = mesh.vertexCount;
        for (int i = 0; i < nVertices; ++i) {
            mesh.addVertexCopy(this.ptList[i]);
        }
        int npoints = nVertices < 3 ? 3 : nVertices;
        mesh.setPolygonCount(nPoly + 1);
        mesh.polygonIndexes[nPoly] = new int[npoints];
        for (int i = 0; i < npoints; ++i) {
            mesh.polygonIndexes[nPoly][i] = nVertices0 + (i < nVertices ? i : nVertices - 1);
        }
        return nPoly + 1;
    }

    private void scaleDrawing(Mesh mesh, float newScale) {
        if (newScale == 0.0f || mesh.vertexCount == 0 || mesh.scale == newScale) {
            return;
        }
        Vector3f diff = new Vector3f();
        float f = newScale / mesh.scale;
        mesh.scale = newScale;
        int iptlast = -1;
        int ipt = 0;
        int i = mesh.polygonCount;
        while (--i >= 0) {
            Point3f center = mesh.ptCenters == null ? mesh.ptCenter : mesh.ptCenters[i];
            iptlast = -1;
            int iV = mesh.polygonIndexes[i].length;
            while (--iV >= 0) {
                ipt = mesh.polygonIndexes[i][iV];
                if (ipt == iptlast) continue;
                iptlast = ipt;
                diff.sub(mesh.vertices[ipt], center);
                diff.scale(f);
                diff.add(center);
                mesh.vertices[ipt].set(diff);
            }
        }
    }

    void setVisibilityFlags(BitSet bs) {
        int modelCount = this.viewer.getModelCount();
        int i = this.meshCount;
        while (--i >= 0) {
            Mesh m = this.meshes[i];
            int n = m.visibilityFlags = m.isValid && m.visible ? this.myVisibilityFlag : 0;
            if (m.modelFlags == null) continue;
            int iModel = modelCount;
            while (--iModel >= 0) {
                m.modelFlags[iModel] = bs.get(iModel) ? 1 : 0;
            }
        }
    }

    void checkObjectDragged(int prevX, int prevY, int deltaX, int deltaY, int modifiers) {
        boolean isPicking;
        boolean bl = isPicking = this.viewer.getPickingMode() == 4;
        if (!isPicking) {
            return;
        }
        if (!this.findPickedObject(prevX, prevY, true)) {
            return;
        }
        boolean moveAll = false;
        switch (modifiers & 0x1F) {
            case 17: {
                moveAll = true;
            }
            case 24: {
                this.move2D(this.pickedMesh, this.pickedMesh.polygonIndexes[this.pickedModel], this.pickedVertex, prevX + deltaX, prevY + deltaY, moveAll);
                this.currentMesh = this.pickedMesh;
                break;
            }
        }
    }

    void move2D(Mesh mesh, int[] vertexes, int iVertex, int x, int y, boolean moveAll) {
        int i;
        Point3i pt = new Point3i();
        Point3f coord = new Point3f();
        boolean addOffset = mesh.drawOffset != null && mesh.drawOffset.length() > 0.0f;
        coord.set(mesh.vertices[vertexes[iVertex]]);
        if (addOffset) {
            coord.add(mesh.drawOffset);
        }
        this.viewer.transformPoint(coord, pt);
        int dx = x - pt.x;
        int dy = y - pt.y;
        int n = i = moveAll ? vertexes.length : iVertex + 1;
        while (--i >= 0) {
            if (!moveAll && i != iVertex) continue;
            if (moveAll) {
                coord.set(mesh.vertices[vertexes[i]]);
                if (addOffset) {
                    coord.add(mesh.drawOffset);
                }
                this.viewer.transformPoint(coord, pt);
            }
            pt.x += dx;
            pt.y += dy;
            this.viewer.unTransformPoint(pt, coord);
            if (addOffset) {
                coord.sub(mesh.drawOffset);
            }
            mesh.vertices[vertexes[i]].set(coord);
            if (moveAll) continue;
        }
        if (Logger.isActiveLevel(1)) {
            Logger.info(this.getDrawCommand(mesh));
        }
        this.viewer.refresh();
    }

    void checkObjectClicked(int x, int y, int modifiers) {
        boolean isPicking;
        boolean bl = isPicking = this.viewer.getPickingMode() == 4;
        if (isPicking) {
            return;
        }
        if (!this.findPickedObject(x, y, false)) {
            return;
        }
        if (this.pickedVertex == 0) {
            this.viewer.startSpinningAxis(this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][0]], this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][1]], (modifiers & 1) != 0);
            return;
        }
        this.viewer.startSpinningAxis(this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][1]], this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][0]], (modifiers & 1) != 0);
    }

    boolean findPickedObject(int x, int y, boolean isPicking) {
        int modelCount = this.viewer.getModelCount();
        int dmin2 = 100;
        this.pickedModel = 0;
        this.pickedVertex = 0;
        this.pickedMesh = null;
        int i = this.meshCount;
        while (--i >= 0) {
            int mCount;
            Mesh m = this.meshes[i];
            if (!isPicking && m.drawVertexCount != 2 || m.visibilityFlags == 0) continue;
            boolean addOffset = m.drawOffset != null && m.drawOffset.length() > 0.0f;
            int iModel = mCount = m.modelFlags == null ? 1 : modelCount;
            while (--iModel >= 0) {
                if (m.modelFlags != null && m.modelFlags[iModel] == 0) continue;
                int iVertex = m.polygonIndexes[iModel].length;
                while (--iVertex >= 0) {
                    int d2;
                    Point3f v = new Point3f();
                    v.set(m.vertices[m.polygonIndexes[iModel][iVertex]]);
                    if (addOffset) {
                        v.add(m.drawOffset);
                    }
                    if ((d2 = this.coordinateInRange(x, y, v, dmin2)) < 0) continue;
                    this.pickedMesh = m;
                    dmin2 = d2;
                    this.pickedModel = iModel;
                    this.pickedVertex = iVertex;
                }
            }
        }
        return this.pickedMesh != null;
    }

    int coordinateInRange(int x, int y, Point3f vertex, int dmin2) {
        int d2 = dmin2;
        this.viewer.transformPoint(vertex, this.ptXY);
        d2 = (x - this.ptXY.x) * (x - this.ptXY.x) + (y - this.ptXY.y) * (y - this.ptXY.y);
        return d2 < dmin2 ? d2 : -1;
    }

    String getDrawCommand(Mesh mesh) {
        int nVertices = 0;
        if (mesh == null) {
            return "no current draw object";
        }
        String str = "draw " + mesh.thisID;
        switch (mesh.drawType) {
            case 1: {
                str = str + " ARROW";
                break;
            }
            case 2: {
                str = str + " CIRCLE";
                break;
            }
            case 3: {
                str = str + " CURVE";
                break;
            }
            case 4: {
                ++nVertices;
            }
            case 6: {
                ++nVertices;
                break;
            }
        }
        int modelIndex = this.viewer.getDisplayModelIndex();
        if (modelIndex < 0) {
            return str;
        }
        int modelCount = this.viewer.getModelCount();
        int mCount = mesh.modelFlags == null ? 1 : modelCount;
        for (int iModel = 0; iModel < mCount; ++iModel) {
            if (mesh.modelFlags != null && mesh.modelFlags[iModel] == 0) continue;
            if (nVertices == 0) {
                nVertices = mesh.polygonIndexes[iModel].length;
            }
            boolean addOffset = mesh.drawOffset != null && mesh.drawOffset.length() > 0.0f;
            for (int i = 0; i < nVertices; ++i) {
                Point3f v = new Point3f();
                v.set(mesh.vertices[mesh.polygonIndexes[iModel][i]]);
                if (addOffset) {
                    v.add(mesh.drawOffset);
                }
                str = str + " {" + v.x + " " + v.y + " " + v.z + "}";
            }
        }
        return str;
    }
}

