/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.dialogs;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.JChemPaintPanel;

public class GeneralFieldEditor
extends JFrame {
    private static final long serialVersionUID = -5332727131588533929L;
    Properties props;
    JChemPaintModel jcpm;
    String[] defaults;
    String[] currentValues;
    JTextField[] fields;
    JChemPaintPanel jcp;

    public GeneralFieldEditor(JChemPaintPanel jcp, String title, String[] fieldTitles, String[] defaults) {
        super(title);
        this.jcp = jcp;
        this.jcpm = jcp.getJChemPaintModel();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel southPanel = new JPanel();
        JButton cancelButton = new JButton("Cancel");
        JButton openButton = new JButton("OK");
        openButton.addActionListener(new UpdateAction());
        cancelButton.addActionListener(new CancelAction());
        southPanel.add(openButton);
        southPanel.add(cancelButton);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridLayout(5, 2));
        this.defaults = defaults;
        this.currentValues = this.defaults;
        this.fields = new JTextField[fieldTitles.length];
        for (int i = 0; i < fieldTitles.length; ++i) {
            JLabel label = new JLabel(fieldTitles[i]);
            JTextField textField = new JTextField("", 20);
            centerPanel.add(label);
            centerPanel.add(textField);
            this.fields[i] = textField;
        }
        this.setSize(100 * this.fields.length, 500);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", centerPanel);
        this.getContentPane().add("South", southPanel);
    }

    public String[] getFieldValues() {
        return this.currentValues;
    }

    public void closeFrame() {
        this.dispose();
    }

    class EditAction
    extends AbstractAction {
        private static final long serialVersionUID = 2240224589987930306L;

        EditAction(String prop) {
            super("Edit");
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 509508358451482801L;

        CancelAction() {
            super("Cancel");
        }

        public void actionPerformed(ActionEvent e) {
            GeneralFieldEditor.this.currentValues = GeneralFieldEditor.this.defaults;
            GeneralFieldEditor.this.closeFrame();
        }
    }

    class UpdateAction
    extends AbstractAction {
        private static final long serialVersionUID = 7477381340397319284L;

        UpdateAction() {
            super("Update");
        }

        public void actionPerformed(ActionEvent event) {
            for (int i = 0; i < GeneralFieldEditor.this.fields.length; ++i) {
                JTextField field = GeneralFieldEditor.this.fields[i];
                GeneralFieldEditor.this.currentValues[i] = field.getText();
            }
            GeneralFieldEditor.this.closeFrame();
        }
    }
}

