% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{emedyd}
\alias{emedyd}
\title{Radiocarbon dates for the Eastern Mediterranean around the Younger Dryas}
\format{
A data.frame with the following variables:
\describe{
\item{\code{LabID}}{Laboratory ID assigned to each radiocarbon date (where known)}
\item{\code{CRA}}{Radiocarbon age in 14C years BP}
\item{\code{Error}}{Radiocarbon age error}
\item{\code{Material}}{Material of the dated sample}
\item{\code{Species}}{Species of the dated sample (where identified)}
\item{\code{SiteName}}{Name of the site from which the sample has been recovered}
\item{\code{Country}}{Country where the sampling site is located}
\item{\code{Longitude}}{Longitude of the sampling site in decimal degrees}
\item{\code{Latitude}}{Latitude of the sampling site in decimal degrees}
\item{\code{Region}}{One of three analytical regions (1=southern Levant, 2=Northern Levant, 3= South-central Anatolia}
}
}
\source{
Palmisano, A., Bevan, A. and S. Shennan 2017. Data and code for demographic trends in the paper "Human responses and non-responses to climatic variations during the Last Glacial-Interglacial transition in the eastern Mediterranean", UCL Discovery Archive 1570274. doi:10.14324/000.ds.1570274.
}
\usage{
emedyd
}
\description{
Radiocarbon dates (n=1915) and site coordinates (n=201) from a paper considering the relationship between human activity in the eastern Mediterranean/Middle East and early Holocene climate change, including the Younger Dryas.
}
\examples{
\dontrun{
data(emedyd)
northernlevant <- emedyd[emedyd$Region=="2",]
bins <- binPrep(northernlevant$SiteName, northernlevant$CRA, h=50)
x <- calibrate(northernlevant$CRA, northernlevant$Error, normalised=FALSE)
spd.northernlevant <- spd(x, bins=bins, runm=50, timeRange=c(17000,8000))
plot(spd.northernlevant)
}
}
\references{
Roberts, N., Woodbridge, J., Bevan, A., Palmisano, A., Shennan, S. and E. Asouti 2017. Human responses and non-responses to climatic variations during the Last Glacial-Interglacial transition in the eastern Mediterranean. Quaternary Science Reviews, 184, 47-67. doi:10.1016/j.quascirev.2017.09.011.
}
\keyword{datasets}
