% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{calibrate}
\alias{calibrate}
\alias{calibrate.default}
\alias{calibrate.UncalGrid}
\title{Calibrate radiocarbon dates}
\usage{
calibrate(x, ...)

\method{calibrate}{default}(x, errors, ids = NA, dateDetails = NA,
  calCurves = "intcal13", resOffsets = 0, resErrors = 0,
  timeRange = c(50000, 0), normalised = TRUE, F14C = FALSE,
  calMatrix = FALSE, eps = 1e-05, ncores = 1, verbose = TRUE, ...)

\method{calibrate}{UncalGrid}(x, errors = 0, calCurves = "intcal13",
  timeRange = c(50000, 0), eps = 1e-05, type = "fast",
  datenormalised = FALSE, spdnormalised = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{x}{A vector of uncalibrated radiocarbon ages or a UncalGrid class object.}

\item{...}{ignored}

\item{errors}{A vector of standard deviations corresponding to each estimated radiocarbon age.}

\item{ids}{An optional vector of IDs for each date.}

\item{dateDetails}{An optional vector of details for each date which will be returned in the output metadata.}

\item{calCurves}{Either a character string naming a calibration curve already provided with the rcarbon package (currently 'intcal13','intcal13nhpine16','shcal13','shcal13shkauri16','marine13' and 'normal'(i.e. no calibration) are possible; default is 'intcal13') or a custom calibration curve as three-column matrix or data.frame (calibrated year BP, uncalibrated age bp, standard deviation). Different existing curves can be specified per dated sample, but only one custom curve can be provided for all dates.}

\item{resOffsets}{A vector of offset values for any marine reservoir effect (default is no offset).}

\item{resErrors}{A vector of offset value errors for any marine reservoir effect (default is no offset).}

\item{timeRange}{Earliest and latest data to calibrate for, in calendar years. Posterior probabilities beyond this range will be excluded (the default is sensible in most cases).}

\item{normalised}{A logical variable indicating whether the calibration should be normalised or not. Default is TRUE.}

\item{F14C}{A logical variable indicating whether calibration should be carried out in F14C space or not. Default is FALSE.}

\item{calMatrix}{a logical variable indicating whether the age grid should be limited to probabilities higher than \code{eps}}

\item{eps}{Cut-off value for density calculation. Default is 1e-5.}

\item{ncores}{Number of cores/workers used for parallel execution. Default is 1 (>1 requires doParallel package).}

\item{verbose}{A logical variable indicating whether extra information on progress should be reported. Default is TRUE.}

\item{type}{Currently, two options are available. With "fast", a look-up is conducted for each calendar year that picks up the amplitude of the nearest CRA age. With "full", each CRA is calibrated individually and then summed (much slower).}

\item{datenormalised}{Controls for calibrated dates with probability mass outside the timerange of analysis. If set to TRUE the total probability mass within the time-span of analysis is normalised to sum to unity. Should be set to FALSE when the parameter \code{normalised} in \code{\link{calibrate}} is set to FALSE. Default is FALSE.}

\item{spdnormalised}{A logical variable indicating whether the total probability mass of the SPD is normalised to sum to unity.}
}
\value{
An object of class CalDates with the following elements:
\itemize{
\item{\code{metadata}} {A data.frame containing relevant information regarding each radiocarbon date and the parameter used in the calibration process.}
\item{\code{grids}} {A list of calGrid class objects, containing the posterior probabilities for each calendar year. The most memory-efficient way to store calibrated dates, as only years with non-zero probability are stored, but aggregation methods such as \code{spd()} may then take longer to extract and combine multiple dates. NA when the parameter calMatrix is set to TRUE.} 
\item{\code{calMatrix}} {A matrix of probability values, one row per calendar year in timeRange and one column per date. By storing all possible years, not just those with non-zero probability, this approach takes more memory, but speeds up spd() and is suggested whenever the latter is to be used. NA when the parameter calMatrix is set to FALSE.}  
}
}
\description{
Function for calibrating radiocarbon dates or uncalibrated SPDs.

Function for calibrating a SPD generated by summing uncalibrated dates.
}
\details{
This function computes one or more calibrated radiocarbon ages using the method described in Bronk Ramsey 2008 (see also  Parnell 2017). It is possible to specify different calibration curves or reservoir offsets individually for each date, and control whether the resulting calibrated distribution is normalised to 1 under-the-curve or not. Calculations can also be executed in parallel to reduce computing time. The function was modified from the \code{BchronCalibrate} function in the \code{Bchron} package developed by A.Parnell (see references below).
}
\examples{
x1 <- calibrate(x=4000, errors=30)
plot(x1)
summary(x1)
# Example with a Marine Date, using a DeltaR of 300 and a DeltaR error of 30
x2 <- calibrate(x=4000, errors=30, calCurves='marine13', resOffsets=300, resErrors=30)
plot(x2)
}
\references{
Bronk Ramsey, C. 2008. Radiocarbon dating: revolutions in understanding, \emph{Archaeometry} 50.2: 249-75. DOI: https://doi.org/10.1111/j.1475-4754.2008.00394.x \cr
Parnell, A. 2017. Bchron: Radiocarbon Dating, Age-Depth Modelling, Relative Sea Level Rate Estimation, and Non-Parametric Phase Modelling, R package: https://CRAN.R-project.org/package=Bchron
}
