% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_text.R
\name{ly_text}
\alias{ly_text}
\title{Add a "text" layer to a Bokeh figure}
\usage{
ly_text(
  fig,
  x,
  y = NULL,
  text = NULL,
  data = figure_data(fig),
  color = "black",
  alpha = 1,
  angle = 0,
  align = NULL,
  baseline = NULL,
  font = NULL,
  font_size = NULL,
  font_style = NULL,
  x_offset = NULL,
  y_offset = NULL,
  legend = NULL,
  lname = NULL,
  lgroup = NULL
)
}
\arguments{
\item{fig}{figure to modify}

\item{x}{x coordinates of text anchors}

\item{y}{y coordinates of text anchors}

\item{text}{text values to render}

\item{data}{an optional data frame, providing the source for inputs x, y, text, and other glyph properties}

\item{color}{text color values for the text}

\item{alpha}{text alpha values for the text}

\item{angle}{angle to rotate the text in radians}

\item{align}{text align values for the text ("left", "right", "center")}

\item{baseline}{text baseline values for the text ("top", "middle", "bottom", "alphabetic", "hanging")}

\item{font}{text font values for the text}

\item{font_size}{text font size values for the text}

\item{font_style}{text font style values for the text ("normal", "italic", "bold")}

\item{x_offset}{offset values to apply to the x-coordinates}

\item{y_offset}{offset values to apply to the y-coordinates}

\item{legend}{either a logical specifying not to plot a legend for this layer (FALSE) or a string indicating the name of the legend entry for this layer (note that when mapping plot attributes to variables in \code{data}, a legend is automatically created and does not need to be specified - see "Mapped plot attributes and legends" below)}

\item{lname}{layer name}

\item{lgroup}{layer group}
}
\description{
Add a "text" layer to a Bokeh figure
}
\section{Mapped plot attributes and legends}{
 When specifying an input data frame for a layer through the \code{data} argument, columns of \code{data} can be used to specify various plot attributes such as \code{color}, etc. For example, with \code{ly_points(..., data = iris, color = Species)}, the \code{Species} variable is used to determine how to color the points.  Here, \code{Species} is "mapped" to the \code{color} attribute.  Both continuous and categorical variables can be mapped.  In the case of continuous variables, the range is cut into slices and attributes are applied to each interval.  The mapping from the values of the variable to the actual plot attributes is determined based on the theme.
}

\examples{
\donttest{
# prepare data
elements <- subset(elements, !is.na(group))
elements$group <- as.character(elements$group)
elements$period <- as.character(elements$period)

# add colors for groups
metals <- c("alkali metal", "alkaline earth metal", "halogen",
  "metal", "metalloid", "noble gas", "nonmetal", "transition metal")
colors <- c("#a6cee3", "#1f78b4", "#fdbf6f", "#b2df8a", "#33a02c",
  "#bbbb88", "#baa2a6", "#e08e79")
elements$color <- colors[match(elements$metal, metals)]
elements$type <- elements$metal

# make coordinates for labels
elements$symx <- paste(elements$group, ":0.1", sep = "")
elements$numbery <- paste(elements$period, ":0.8", sep = "")
elements$massy <- paste(elements$period, ":0.15", sep = "")
elements$namey <- paste(elements$period, ":0.3", sep = "")

# create figure
p <- figure(title = "Periodic Table", tools = "",
  ylim = as.character(c(7:1)), xlim = as.character(1:18),
  xgrid = FALSE, ygrid = FALSE, xlab = "", ylab = "",
  height = 600, width = 1200) \%>\%

# plot rectangles
ly_crect(group, period, data = elements, 0.9, 0.9,
  fill_color = color, line_color = color, fill_alpha = 0.6,
  hover = list(name, atomic.number, type, atomic.mass,
    electronic.configuration)) \%>\%

# add symbol text
ly_text(symx, period, text = symbol, data = elements,
  font_style = "bold", font_size = "15pt",
  align = "left", baseline = "middle") \%>\%

# add atomic number text
ly_text(symx, numbery, text = atomic.number, data = elements,
  font_size = "9pt", align = "left", baseline = "middle") \%>\%

# add name text
ly_text(symx, namey, text = name, data = elements,
  font_size = "6pt", align = "left", baseline = "middle") \%>\%

# add atomic mass text
ly_text(symx, massy, text = atomic.mass, data = elements,
  font_size = "6pt", align = "left", baseline = "middle")

p
}
}
\seealso{
Other layer functions: 
\code{\link{ly_abline}()},
\code{\link{ly_annular_wedge}()},
\code{\link{ly_annulus}()},
\code{\link{ly_arc}()},
\code{\link{ly_bar}()},
\code{\link{ly_bezier}()},
\code{\link{ly_boxplot}()},
\code{\link{ly_contour}()},
\code{\link{ly_crect}()},
\code{\link{ly_curve}()},
\code{\link{ly_density}()},
\code{\link{ly_hist}()},
\code{\link{ly_image_url}()},
\code{\link{ly_image}()},
\code{\link{ly_lines}()},
\code{\link{ly_map}()},
\code{\link{ly_multi_line}()},
\code{\link{ly_oval}()},
\code{\link{ly_patch}()},
\code{\link{ly_points}()},
\code{\link{ly_polygons}()},
\code{\link{ly_quadratic}()},
\code{\link{ly_quantile}()},
\code{\link{ly_ray}()},
\code{\link{ly_rect}()},
\code{\link{ly_segments}()},
\code{\link{ly_wedge}()}
}
\concept{layer functions}
