% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figure.R
\name{figure}
\alias{figure}
\title{Initialize a Bokeh figure}
\usage{
figure(data = NULL, width = NULL, height = NULL, title = NULL,
  xlab = NULL, ylab = NULL, xlim = NULL, ylim = NULL,
  padding_factor = 0.07, xgrid = TRUE, ygrid = TRUE, xaxes = "below",
  yaxes = "left", legend_location = "top_right", tools = c("pan",
  "wheel_zoom", "box_zoom", "reset", "save", "help"),
  theme = getOption("bokeh_theme"), toolbar_location = "above",
  h_symmetry = TRUE, v_symmetry = FALSE, logo = NULL, lod_factor = 10,
  lod_interval = 300, lod_threshold = NULL, lod_timeout = 500,
  webgl = FALSE, ...)
}
\arguments{
\item{data}{data to be supplied to all layers, if the layer doesn't supply a data value}

\item{width}{figure width in pixels}

\item{height}{figure width in pixels}

\item{title}{a title to display above the plot. - "title" is also the prefix for a set of Text Properties, so you can set the font for the title with the parameter text_font.}

\item{xlab}{label for x axis}

\item{ylab}{label for y axis}

\item{xlim}{the extent of the plotting area in the x-dimension (will be computed automatically if not specified).}

\item{ylim}{the extent of the plotting area in the y-dimension (will be computed automatically if not specified).}

\item{padding_factor}{if limits are not specified, by what factor should the extents of the data be padded}

\item{xgrid}{whether to draw x axis grid lines}

\item{ygrid}{whether to draw y axis grid lines}

\item{xaxes}{where to put x axis, or FALSE if no x axis ticks / labels}

\item{yaxes}{where to put y axis, or FALSE if no y axis ticks / labels}

\item{legend_location}{('top_right', 'top_left', 'bottom_left', 'bottom_right') the location where the legend should draw itself, or NULL to omit the legend}

\item{tools}{character vector of interactivity tools options (acceptable values are: "pan", "wheel_zoom", "box_zoom", "resize", "crosshair", "box_select", "lasso_select", "reset", "save", "help").  Additionally, tool functions can be called on a figure to specify more control - see the "See Also" section below for a list of tool functions.  If \code{NULL}, the toolbar will not be drawn.  If \code{""} the toolbar will be drawn but no tools will be added by default.}

\item{theme}{an rbokeh theme to use}

\item{toolbar_location}{('above', 'below', 'left', 'right') Where the toolbar will be located. If set to NULL, no toolbar will be attached to the plot.}

\item{h_symmetry}{(logical) Whether the total horizontal padding on both sides of the plot will be made equal (the left or right padding amount, whichever is larger).}

\item{v_symmetry}{(logical) Whether the total vertical padding on both sides of the plot will be made equal (the top or bottom padding amount, whichever is larger).}

\item{logo}{('normal', 'grey') What version of the Bokeh logo to display on the toolbar. If set to NULL, no logo will be displayed.}

\item{lod_factor}{(integer) Decimation factor to use when applying level-of-detail decimation (see "Controlling level of detail").}

\item{lod_interval}{(integer) Interval (in ms) during which an interactive tool event will enable level-of-detail downsampling (see "Controlling level of detail").}

\item{lod_threshold}{(integer) A number of data points, above which level-of-detail downsampling may be performed by glyph renderers. Set to \code{NULL} to disable any level-of-detail downsampling (see "Controlling level of detail").}

\item{lod_timeout}{(integer) Timeout (in ms) for checking whether interactive tool events are still occurring. Once level-of-detail mode is enabled, a check is made every lod_timeout ms. If no interactive tool events have happened, level-of-detail mode is disabled (see "Controlling level of detail").}

\item{webgl}{(logical) should webgl be used for rendering?}

\item{\ldots}{parameters can be specified here that are available in \code{\link{theme_plot}}}
}
\description{
Initialize a Bokeh figure
}
\section{Controlling level of detail}{

Although the HTML canvas can comfortably display tens or even hundreds of thousands of glyphs, doing so can have adverse affects on interactive performance. In order to accommodate large-ish (but not enormous) data sizes, Bokeh plots offer "Level of Detail" (LOD) capability in the client.

The basic idea is that during interactive operations (e.g., panning or zooming), the plot only draws some small fraction data points. This hopefully allows the general sense of the interaction to be preserved mid-flight, while maintaining interactive performance. See the \code{lod_} parameters for information on how to control this.
}
\examples{
figure() \%>\% ly_points(1:10)
}
\seealso{
Layers to add to a figure: \code{\link{ly_abline}};
  \code{\link{ly_annular_wedge}}; \code{\link{ly_annulus}};
  \code{\link{ly_arc}}; \code{\link{ly_bezier}};
  \code{\link{ly_boxplot}}; \code{\link{ly_contour}};
  \code{\link{ly_crect}}; \code{\link{ly_curve}};
  \code{\link{ly_density}}; \code{\link{ly_hist}};
  \code{\link{ly_image_url}}; \code{\link{ly_image}};
  \code{\link{ly_lines}}; \code{\link{ly_map}};
  \code{\link{ly_multi_line}}; \code{\link{ly_oval}};
  \code{\link{ly_patch}}; \code{\link{ly_points}};
  \code{\link{ly_polygons}}; \code{\link{ly_quadratic}};
  \code{\link{ly_quantile}}; \code{\link{ly_ray}};
  \code{\link{ly_segments}}; \code{\link{ly_text}};
  \code{\link{ly_wedge}}
Tools to add to a figure: \code{\link{tool_box_select}};
  \code{\link{tool_box_zoom}};
  \code{\link{tool_crosshair}};
  \code{\link{tool_lasso_select}};
  \code{\link{tool_reset}}; \code{\link{tool_resize}};
  \code{\link{tool_save}}; \code{\link{tool_wheel_zoom}}
Other figure types: \code{\link{grid_plot}}; \code{\link{gmap}}
}

