% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmrm.R
\name{eval_glmmtmb}
\alias{eval_glmmtmb}
\title{Evaluate a call to glmmTMB}
\usage{
eval_glmmtmb(expr)
}
\arguments{
\item{expr}{An expression to be evaluated. Should be a call to \code{\link[glmmTMB:glmmTMB]{glmmTMB::glmmTMB()}}.}
}
\description{
This is a utility function that attempts to evaluate a call to glmmTMB
managing any warnings or errors that are thrown. In particular
this function attempts to catch any warnings or errors and instead
of surfacing them it will simply add an additional element \code{failed}
with a value of TRUE.  This allows for multiple calls to be made
without the program exiting. Additionally this function will suppress
known spurious warnings associated with glmmTMB, namely:
}
\details{
\itemize{
\item https://stackoverflow.com/questions/67040472/warning-in-every-model-of-glmmtmb-givecsparse
}
}
\examples{
\dontrun{
    eval_glmmtmb({glmmTMB::glmmTMB(formula, data)})
}
}
\seealso{
\code{\link[glmmTMB:glmmTMB]{glmmTMB::glmmTMB()}}

\code{\link[=record]{record()}}
}
