% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa_stacked.r
\name{taxa_stacked}
\alias{taxa_stacked}
\title{Display taxa abundances as a stacked bar graph.}
\usage{
taxa_stacked(
  biom,
  rank = -1,
  taxa = 6,
  colors = TRUE,
  patterns = FALSE,
  label.by = NULL,
  order.by = NULL,
  facet.by = NULL,
  dist = "euclidean",
  clust = "complete",
  other = TRUE,
  unc = "singly",
  lineage = FALSE,
  xlab.angle = 90,
  ...
)
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{rank}{What rank(s) of taxa to display. E.g. \code{"Phylum"},
\code{"Genus"}, \code{".otu"}, etc. An integer vector can also be
given, where \code{1} is the highest rank, \code{2} is the second
highest, \code{-1} is the lowest rank, \code{-2} is the second
lowest, and \code{0} is the OTU "rank". Run \code{biom$ranks} to
see all options for a given rbiom object. Default: \code{-1}.}

\item{taxa}{Which taxa to display. An integer value will show the top n
most abundant taxa. A value 0 <= n < 1 will show any taxa with that
mean abundance or greater (e.g. \code{0.1} implies >= 10\%). A
character vector of taxa names will show only those named taxa.
Default: \code{6}.}

\item{colors, patterns}{A character vector of colors or patterns to use in
the graph. A named character vector can be used to map taxon names to
specific colors or patterns. Set to \code{TRUE} to auto-select colors
or patterns, or to \code{FALSE} to disable per-taxa colors or patterns.
Default: \code{colors=TRUE, patterns=FALSE}.}

\item{label.by, order.by}{What metadata column to use for labeling and/or
sorting the samples across the x-axis. Set \code{label.by='.sample'}
to display sample names. When \code{order.by=NULL}, samples are
arranged based on \code{dist} and \code{clust}, below.
Default: \code{label.by=NULL, order.by=NULL}.}

\item{facet.by}{Dataset field(s) to use for faceting. Must be categorical.
Default: \code{NULL}}

\item{dist, clust}{Distance (\code{\link[stats:dist]{stats::dist()}}) and clustering
(\code{\link[stats:hclust]{stats::hclust()}}) methods to use for automatically arranging
samples along the x-axis to put samples with similar composition near
one another. Default: \code{dist="euclidean", clust="complete"}.}

\item{other}{Sum all non-itemized taxa into an "Other" taxa. When
\code{FALSE}, only returns taxa matched by the \code{taxa}
argument. Specifying \code{TRUE} adds "Other" to the returned set.
A string can also be given to imply \code{TRUE}, but with that
value as the name to use instead of "Other".
Default: \code{FALSE}}

\item{unc}{How to handle unclassified, uncultured, and similarly ambiguous
taxa names. Options are:
\describe{
\item{\code{"singly"} - }{ Replaces them with the OTU name. }
\item{\code{"grouped"} - }{ Replaces them with a higher rank's name. }
\item{\code{"drop"} - }{ Excludes them from the result. }
\item{\code{"asis"} - }{ To not check/modify any taxa names. }
}
Abbreviations are allowed. Default: \code{"singly"}}

\item{lineage}{Include all ranks in the name of the taxa. For instance,
setting to \code{TRUE} will produce
\verb{Bacteria; Actinobacteria; Coriobacteriia; Coriobacteriales}.
Otherwise the taxa name will simply be \code{Coriobacteriales}. You
want to set this to TRUE when \code{unc = "asis"} and you have taxa
names (such as \emph{Incertae_Sedis}) that map to multiple higher
level ranks. Default: \code{FALSE}}

\item{xlab.angle}{Angle of the labels at the bottom of the plot.
Options are \code{"auto"}, \code{'0'}, \code{'30'}, and \code{'90'}.
Default: \code{"auto"}.}

\item{...}{Parameters for underlying functions. Prefixing parameter names
with a layer name ensures that a particular parameter is passed to,
and only to, that layer.}
}
\value{
A \code{ggplot2} plot. The computed data points and ggplot
command are available as \verb{$data} and \verb{$code},
respectively.
}
\description{
Display taxa abundances as a stacked bar graph.
}
\examples{
    library(rbiom)
    
    biom <- rarefy(hmp50)
    
    taxa_stacked(biom, rank="Phylum")
    
    taxa_stacked(biom, rank = "genus", facet.by = "body site")
    
}
\seealso{
Other taxa_abundance: 
\code{\link{sample_sums}()},
\code{\link{taxa_boxplot}()},
\code{\link{taxa_clusters}()},
\code{\link{taxa_corrplot}()},
\code{\link{taxa_heatmap}()},
\code{\link{taxa_stats}()},
\code{\link{taxa_sums}()},
\code{\link{taxa_table}()}

Other visualization: 
\code{\link{adiv_boxplot}()},
\code{\link{adiv_corrplot}()},
\code{\link{bdiv_boxplot}()},
\code{\link{bdiv_corrplot}()},
\code{\link{bdiv_heatmap}()},
\code{\link{bdiv_ord_plot}()},
\code{\link{plot_heatmap}()},
\code{\link{rare_corrplot}()},
\code{\link{rare_multiplot}()},
\code{\link{rare_stacked}()},
\code{\link{stats_boxplot}()},
\code{\link{stats_corrplot}()},
\code{\link{taxa_boxplot}()},
\code{\link{taxa_corrplot}()},
\code{\link{taxa_heatmap}()}
}
\concept{taxa_abundance}
\concept{visualization}
