% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaspar.R
\name{rba_jaspar_matrix}
\alias{rba_jaspar_matrix}
\title{Get a Position Frequency Matrices (PFM) with annotations}
\usage{
rba_jaspar_matrix(matrix_id, file_format = NULL, save_to = NULL, ...)
}
\arguments{
\item{matrix_id}{Character: A matrix profile
Identifier. It has "base_id.version" naming schema.}

\item{file_format}{Character: Instead of returning a R object, you
can directly download the profile matrix in file with this format.
Supported formats are: "yaml", "jaspar", "transfac", "meme" and "pfm"}

\item{save_to}{NULL or Character:\itemize{
\item NULL: (only if file_format was supplied) Save the file to an
  automatically-generated path.
\item Character string: A valid file or directory path to save the file to.}}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list that contains the PFM along with its details and
  annotations. If file_format was supplied, an un-parsed character string
  with the file's content.
}
\description{
Using this function you can retrieve a Position Frequency Matrices (PFM)
 associated with a matrix profile Identifier along with its details and
 annotations. If a base ID (i.e. without version suffix) was supplied,
 the latest version will be returned.
}
\section{Corresponding API Resources}{

 "GET https://jaspar.elixir.no/api/v1/matrix/\{matrix_id\}/"
}

\examples{
\donttest{
rba_jaspar_matrix("MA0600.2")
}
\dontrun{
rba_jaspar_matrix(matrix_id = "MA0600.2",
                  file_format = "meme",
                  save_to = "my_matrix.meme")
}

}
\references{
\itemize{
  \item Rauluseviciute I, Riudavets-Puig R, Blanc-Mathieu R,
  Castro-Mondragon JA, Ferenc K, Kumar V, Lemma RB, Lucas J, Chèneby J,
  Baranasic D, Khan A, Fornes O, Gundersen S, Johansen M, Hovig E, Lenhard
  B, Sandelin A, Wasserman WW, Parcy F, Mathelier A JASPAR 2024:
  20th anniversary of the open-access database of transcription factor
  binding profiles Nucleic Acids Res. in_press; doi: 10.1093/nar/gkad1059
  \item Khan, A. and Mathelier, A. JASPAR RESTful API: accessing JASPAR data
  from any programming language. Bioinformatics, 2017,
  doi: 10.1093/bioinformatics/btx804
  \item
  \href{https://jaspar.elixir.no/api/v1/docs/}{JASPAR API Documentation}
  \item \href{https://jaspar.elixir.no/faq/}{Citations note
  on JASPAR website}
  }
}
\seealso{
Other "JASPAR": 
\code{\link{rba_jaspar_collections}()},
\code{\link{rba_jaspar_collections_matrices}()},
\code{\link{rba_jaspar_matrix_search}()},
\code{\link{rba_jaspar_matrix_versions}()},
\code{\link{rba_jaspar_releases}()},
\code{\link{rba_jaspar_sites}()},
\code{\link{rba_jaspar_species}()},
\code{\link{rba_jaspar_species_matrices}()},
\code{\link{rba_jaspar_taxons}()},
\code{\link{rba_jaspar_taxons_matrices}()},
\code{\link{rba_jaspar_tffm}()},
\code{\link{rba_jaspar_tffm_search}()}
}
\concept{"JASPAR"}
