% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringdb.R
\name{rba_string_map_ids}
\alias{rba_string_map_ids}
\title{Map a Set of Identifiers to STRING Identifiers}
\usage{
rba_string_map_ids(ids, species = NULL, echo_query = FALSE, limit = NULL, ...)
}
\arguments{
\item{ids}{Your Common gene/protein Identifier(s) to be mapped.}

\item{species}{Numeric: NCBI Taxonomy identifier; Human Taxonomy ID is 9606.
(Recommended, but optional if your input is less than 100 IDs.)}

\item{echo_query}{(default = FALSE) Include your input IDs as a column of the
results.}

\item{limit}{(Numeric, Optional) A limit on the number of matches per input
ID. The output are sorted to have the best matches first.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A data frame with the mapped STRING IDs and other pertinent
  information.
}
\description{
This function Calls STRING's API to Convert a set of identifiers
  to STRING Identifiers. Although You can call STRING services with a variety
  of common identifiers, It is recommended by STRING's documentations that
  you first map Your Protein/genes IDs to STRING IDs and then proceed
  with other STRING's functions.
}
\section{Corresponding API Resources}{

 "POST https://string-db.org/api/\{output-format\}/get_string_ids?identifiers=
 \{your_identifiers\}&\{optional_parameters\}"
}

\examples{
\donttest{
rba_string_map_ids(ids = c("TP53", "TNF", "EGFR"), species = 9606)
}

}
\references{
\itemize{
  \item Damian Szklarczyk, Rebecca Kirsch, Mikaela Koutrouli, Katerina
   Nastou, Farrokh Mehryary, Radja Hachilif, Annika L Gable, Tao Fang,
   Nadezhda T Doncheva, Sampo Pyysalo, Peer Bork, Lars J Jensen, Christian
   von Mering, The STRING database in 2023: protein–protein association
   networks and functional enrichment analyses for any sequenced genome of
   interest, Nucleic Acids Research, Volume 51, Issue D1, 6 January 2023,
   Pages D638–D646, https://doi.org/10.1093/nar/gkac1000
  \item \href{https://string-db.org/help/api/}{STRING API Documentation}
  \item
  \href{https://string-db.org/cgi/about?footer_active_subpage=references}{
  Citations note on STRING website}
  }
}
\seealso{
Other "STRING": 
\code{\link{rba_string_annotations}()},
\code{\link{rba_string_enrichment}()},
\code{\link{rba_string_enrichment_ppi}()},
\code{\link{rba_string_homology_inter}()},
\code{\link{rba_string_homology_intra}()},
\code{\link{rba_string_interaction_partners}()},
\code{\link{rba_string_interactions_network}()},
\code{\link{rba_string_network_image}()},
\code{\link{rba_string_version}()}
}
\concept{"STRING"}
