% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_proteins.R
\name{rba_uniprot_features}
\alias{rba_uniprot_features}
\title{Get UniProt protein sequence features by accession}
\usage{
rba_uniprot_features(accession, types = NULL, categories = NULL, ...)
}
\arguments{
\item{accession}{\href{https://www.uniprot.org/help/accession_numbers}{
UniProtKB primary or secondary accession}.}

\item{types}{\href{https://www.uniprot.org/help/sequence_annotation}{
Sequence annotation (Features)} types. accepted values
are: "INIT_MET", "SIGNAL", "PROPEP", "TRANSIT", "CHAIN", "PEPTIDE",
"TOPO_DOM", "TRANSMEM", "DOMAIN", "REPEAT", "CA_BIND", "ZN_FING",
"DNA_BIND", "NP_BIND", "REGION", "COILED", "MOTIF", "COMPBIAS",
"ACT_SITE", "METAL", "BINDING", "SITE", "NON_STD", "MOD_RES", "LIPID",
"CARBOHYD", "DISULFID", "CROSSLNK", "VAR_SEQ", "VARIANT", "MUTAGEN",
"UNSURE", "CONFLICT", "NON_CONS", "NON_TER", "HELIX", "TURN", "STRAND"
and/or "INTRAMEM". You can supply up to 20 types.}

\item{categories}{\href{https://www.uniprot.org/help/sequence_annotation}{
Sequence annotation (Features)} categories (subsection). accepted values
are: "MOLECULE_PROCESSING", "TOPOLOGY", "SEQUENCE_INFORMATION",
"STRUCTURAL", "DOMAINS_AND_SITES", "PTM", "VARIANTS" and/or "MUTAGENESIS".
You can supply up to 8 categories.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list in which you can find all of your given protein's sequence
  annotations in a sub-list named "features".
}
\description{
Use this function to retrieve
\href{https://www.uniprot.org/help/sequence_annotation}{sequence annotations
  (features)} of a protein by it's UniProt accession.
}
\section{Corresponding API Resources}{

 "GET https://www.ebi.ac.uk/proteins/api/features/{accession}"
}

\examples{
\donttest{
rba_uniprot_features("Q99616")
}
\donttest{
rba_uniprot_features(accession = "Q99616", types = "DISULFID")
}

}
\references{
\itemize{
  \item The UniProt Consortium, UniProt: the universal protein
  knowledgebase in 2021, Nucleic Acids Research, Volume 49, Issue D1,
  8 January 2021, Pages D480–D489, https://doi.org/10.1093/nar/gkaa1100
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Features": 
\code{\link{rba_uniprot_features_search}()}
}
\concept{"UniProt - Features"}
