% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_complex_list}
\alias{rba_reactome_complex_list}
\title{Get Complexes That Include a Molecule}
\usage{
rba_reactome_complex_list(id, resource, ...)
}
\arguments{
\item{id}{Molecule's external Identifier}

\item{resource}{What is the resource of your supplied ID? see:
\href{https://reactome.org/content/schema/objects/ReferenceDatabase/}{Reactome External
Identifiers}}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
Data frame where each row is a complex containing your supplied
  molecule and columns are pertinent information.
}
\description{
This function will retrieve a list of complexes that include your supplied
  molecule as a component.
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService/data/complexes/{resource}/
 {identifier}"
}

\examples{
\donttest{
rba_reactome_complex_list(id = "3845", resource = "NCBI Gene")
}
\donttest{
rba_reactome_complex_list(id = "P00533", resource = "UniProt")
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  \item \href{https://reactome.org/cite/}{Citations note on Reactome website}
  }
}
\seealso{
Other "Reactome Content Service - Physical Entity Queries": 
\code{\link{rba_reactome_complex_subunits}()},
\code{\link{rba_reactome_entity_other_forms}()},
\code{\link{rba_reactome_participant_of}()}
}
\concept{"Reactome Content Service - Physical Entity Queries"}
