% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_namegetdetail.R
\name{bhl_namemetadata}
\alias{bhl_namemetadata}
\title{Get basic title, item, and page metadata for each page on which the
specified name appears.}
\usage{
bhl_namemetadata(
  namebankid = NULL,
  name = NULL,
  id_type = NULL,
  as = "list",
  key = NULL,
  ...
)
}
\arguments{
\item{namebankid}{(numeric) (not used if 'name' specified) NameBank
identifier for a name}

\item{name}{(character) (not used if 'namebankid' specified) a
complete name string}

\item{id_type}{(character) the type of identifier (namebank, eol, gni,
ion, col, gbif, itis, ipni, worms). Not used if name is specified}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"),
or parsed table ("table", default). Note that \code{as="table"} can give
different data format back depending on the function - for example,
sometimes a data.frame and sometimes a character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron}
as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\description{
Get basic title, item, and page metadata for each page on which the
specified name appears.
}
\examples{
\dontrun{
res <- bhl_namemetadata(name = 'poa annua linnaeus')
str(res)
# bhl_namemetadata(namebankid = 3501464)
}
}
