% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbcb_get_market_expectations.R
\name{get_twelve_months_inflation_expectations}
\alias{get_twelve_months_inflation_expectations}
\title{Get inflation's market expectations for the next 12 months}
\usage{
get_twelve_months_inflation_expectations(indic, start_date = NULL,
  end_date = NULL, ...)
}
\arguments{
\item{indic}{a character vector with economic indicators names:
IGP-DI, IGP-M, INPC, IPA-DI, IPA-M, IPCA, IPCA-15, IPC-Fipe.}

\item{start_date}{series initial date.
Accepts ISO character formated date and \code{Date}.}

\item{end_date}{series final date.
Accepts ISO character formated date and \code{Date}.}

\item{...}{additional parameters to be passed to the API

\code{indic} argumento must be one of these:
IGP-DI, IGP-M, INPC, IPA-DI, IPA-M, IPCA, IPCA-15, IPC-Fipe.
Respecting the case, blank spaces and accents.

The \code{...} is to be used with API's parameters. \code{$top} to specify
the maximum number of rows to be returned, this returns the \code{$top} rows,
in chronological order. There is also \code{$skip} to ignore the first rows.}
}
\value{
A \code{data.frame} with the following ten columns: \code{date}, \code{indic},
\code{smoothed}, \code{mean}, \code{median}, \code{sd},
\code{coefvar}, \code{min}, \code{max}.
}
\description{
Statistics of inflation's market expectations for the next 12 months:
mean, median, standard
deviate, minimum, maximum and the coefficient of variation.
All statistics are computed based on expectations provided by many financial
institutions in Brazil: banks, funds, risk managers, so on and so forth.
These expections and its statistics are used to build the FOCUS Report weekly
released by the Brazilian Central Bank.
}
\details{
There are inflation's expectations available for the following indicators:
IGP-DI, IGP-M, INPC, IPA-DI, IPA-M, IPCA, IPCA-15, IPC-Fipe.
}
\examples{
indic <- c("IPCA", "IGP-M")
end_date <- "2018-06-22"
x <- get_twelve_months_inflation_expectations(indic, end_date = end_date, `$top` = 10)

}
