% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawr.R
\name{rawr}
\alias{rawr}
\title{Retrieve raw R code from any github, kaggle, stack overflow, blogdown, or data camp web page}
\usage{
rawr(url, to_file, file_path, method, padding)
}
\arguments{
\item{url}{Link to an R file on supported website (github, kaggle, tidytext)}

\item{to_file}{Boolean to state whether to return output into a new file. Default is false.}

\item{file_path}{Specifies a file path and file name. The default is to
create a randomly named temp file (see ?tempfile for further information)}

\item{method}{Not all websites are formatted consistently. To overcome this, rawr may have
more than one method for any site. If what rawr returns is not sensible, try setting method
parameter to integers 2 and greater to try other available methods}

\item{padding}{Specify what goes between the last character of one code block and the
first character of the next code block. Default is a two new lines, which appears
visually as one new line between code blocks.}
}
\value{
A character vector of length 1. rawr attempts to retrieve and return the raw R code it
    finds at the target url. In the case of blogdown pages, all code will be returned (not just)
    R code, and in the case of kaggle, all of R (R markdown) and Python code will be returned.
}
\description{
Retrieve raw R code from any github, kaggle, stack overflow, blogdown, or data camp web page
}
\examples{
\dontrun{
library(dplyr)
rawr("https://github.com/hadley/vis-eda/blob/master/travel.R")

# Same as above but provided to cat for easy viewing
rawr("https://github.com/hadley/vis-eda/blob/master/travel.R") \%>\%
  cat


# Use on multiple urls

domains <- c("https://github.com/hadley/vis-eda/blob/master/travel.R",
"https://www.tidytextmining.com/sentiment.html",
"https://www.kaggle.com/vrtjso/mercari-eda-more-info-than-you-can-imagine",
"https://www.jtimm.net/2019/04/14/lexical-change-procrustes/")

domains \%>\% sapply(rawr)

# Write output to a temp file
  "https://www.tidytextmining.com/sentiment.html" \%>\%
    rawr(to_file = TRUE)

# Or to a new file (provide a file name)
"https://www.tidytextmining.com/sentiment.html" \%>\%
  rawr(to_file = TRUE, file_path = "yourfile.R")

}

}
