% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst.R
\name{load_fst_or_h5}
\alias{load_fst_or_h5}
\title{Function try to load 'fst' arrays, if not found, read 'HDF5' arrays}
\usage{
load_fst_or_h5(
  fst_path,
  h5_path,
  h5_name,
  fst_need_transpose = FALSE,
  fst_need_drop = FALSE,
  ram = FALSE
)
}
\arguments{
\item{fst_path}{'fst' file cache path}

\item{h5_path}{alternative 'HDF5' file path}

\item{h5_name}{'HDF5' data name}

\item{fst_need_transpose}{does 'fst' data need transpose?}

\item{fst_need_drop}{drop dimensions}

\item{ram}{whether to load to memory directly or perform lazy loading}
}
\value{
If 'fst' cache file exists, returns \code{\link{LazyFST}} object,
otherwise returns \code{\link{LazyH5}} instance
}
\description{
Function try to load 'fst' arrays, if not found, read 'HDF5' arrays
}
\details{
RAVE stores data with redundancy. One electrode data
is usually saved with two copies in different formats: 'HDF5' and
'fst', where 'HDF5' is cross-platform and supported by multiple
languages such as \code{Matlab}, \code{Python}, etc, while 'fst'
format is supported by R only, with super high read/write speed.
\code{load_fst_or_h5} checks whether the presence of 'fst' file,
if failed, then it reads data from persistent 'HDF5' file.
}
