% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abs-api-functions.R
\name{abs_search}
\alias{abs_search}
\title{Search dataset information from the ABS.Stat API}
\usage{
abs_search(
  pattern,
  dataset = NULL,
  ignore.case = TRUE,
  code_only = FALSE,
  update_cache = FALSE
)
}
\arguments{
\item{pattern}{Character string or regular expression to be matched.}

\item{dataset}{Character vector of ABS.Stat dataset codes. These codes correspond to the
\code{indicatorID} column from the indicator data frame of \code{abs_cache} or
\code{abs_cachelist}, or the result of \code{abs_indicators}. If NULL (default), then function
undertakes a dataset mode search. If not NULL, function searches all dimensions of specified
dataset.}

\item{ignore.case}{Case senstive pattern match or not.}

\item{code_only}{If FALSE (default), all column/fields are returned. If TRUE, only the dataset
identifier or indicator code are returned.}

\item{update_cache}{Logical expression, if FALSE (default), use the cached list of available
ABS.Stat datasets, if TRUE, update the list of available datasets.}
}
\value{
A data frame with datasets and data items that match the search pattern.
}
\description{
This function finds datasets or dimensions within a specific that match a specified
  regular expresion and returns matching results.
}
\note{
With acknowledgements to \code{wb_search} function.
}
\examples{
 ## ABS dataset search
 x <- abs_search(pattern = "consumer price index")
 x <- abs_search(pattern = "census")
 x <- abs_search(pattern = "labour force")

 ## ABS indicator search
 x <- abs_search(pattern = "all groups", dataset="CPI")
 x <- abs_search(pattern = c("all groups", "capital cities"), dataset="CPI")

}
\author{
David Mitchell <david.pk.mitchell@gmail.com>
}
