% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rateci.R
\name{scaspci}
\alias{scaspci}
\title{Skewness-corrected asymptotic score ("SCAS") confidence intervals for
single binomial or Poisson rate using closed-form calculations.
This function is vectorised in x, n.}
\usage{
scaspci(x, n, distrib = "bin", level = 0.95, cc = FALSE, ...)
}
\arguments{
\item{x}{Numeric vector of number of events.}

\item{n}{Numeric vector of sample sizes (for binomial rates) or exposure
times (for Poisson rates).}

\item{distrib}{Character string indicating distribution assumed for the input
data: "bin" = binomial (default), "poi" = Poisson.}

\item{level}{Number specifying confidence level (between 0 and 1, default
0.95).}

\item{cc}{Number or logical (default FALSE) specifying (amount of) continuity
correction. Numeric value is taken as the gamma parameter in Laud 2017,
Appendix S2 (default 0.5 if cc=TRUE).
IMPORTANT NOTES:
1) This is a 'continuity correction' aimed at approximating strictly
conservative coverage, NOT for dealing with zero cell counts. Such
'sparse data adjustments' are not needed in the score method.
2) The continuity corrections provided here have not been fully tested for
stratified methods.}

\item{...}{Other arguments.}
}
\description{
Skewness-corrected asymptotic score ("SCAS") confidence intervals for
single binomial or Poisson rate using closed-form calculations.
This function is vectorised in x, n.
}
