% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairbinci.R
\name{pairbinci}
\alias{pairbinci}
\title{Skewness-corrected confidence intervals for comparisons of paired binomial
rates.}
\usage{
pairbinci(x, contrast = "RD", level = 0.95, delta = NULL)
}
\arguments{
\item{x}{A numeric vector object specified as c(a,b,c,d) 
where:
a is the number of pairs with the event (e.g. success) under both conditions 
  (e.g. treated/untreated, or case/control)
b is the count of the number with the event on condition 1 only 
c is the count of the number with the event on condition 2 only
d is the number of pairs with no event under both conditions
(Note the order of a and d is only important for contrast="RR".)
Note for data in columns of success/failure, use the tdasci function instead
(not recommended for contrast="OR")}

\item{contrast}{Character string indicating the contrast of interest: 
"RD" = rate difference (default), "RR" = rate ratio, "OR" = odds ratio.}

\item{level}{Number specifying confidence level (between 0 and 1, default 
0.95).}

\item{delta}{Number to be used in a one-sided significance test (e.g. 
non-inferiority margin). 1-sided p-value will be <0.025 iff 2-sided 95\% CI
excludes delta. NB: can also be used for a superiority test by setting 
delta=0.}
}
\description{
Score-based confidence intervals for the rate (or risk) difference ("RD"), rate 
ratio ("RR") or for odds ratio ("OR"), for paired binomial data. 
[For paired Poisson rates, use the tdasci function with distrib="poi",
with pairs as strata.].
This function applies the stratified TDAS method for RD and RR. For OR, an 
interval is produced based on transforming a SCAS interval for the single 
proportion.
}
\examples{
 
  #Data example from Agresti-Min 2005
  pairbinci(c(53,16,8,9),contrast="RD")
  pairbinci(c(53,16,8,9),contrast="RR")
  pairbinci(c(53,16,8,9),contrast="OR")
}
\author{
Pete Laud, \email{p.j.laud@sheffield.ac.uk}
}
\references{
Laud PJ. Equal-tailed confidence intervals for comparison of 
  rates. Pharmaceutical Statistics [in press].
  
  Fagerland MW, Lydersen S, Laake P. Recommended tests and
  confidence intervals for paired binomial proportions. Statistics in
  Medicine 2014; 33(16):2850–2875
}

