% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heliPlot.R
\name{heliPlot}
\alias{heliPlot}
\title{Create a Helical Plot for Time Series Data}
\usage{
heliPlot(
  data,
  group = NULL,
  facet = FALSE,
  xlabel = "Rate of Change",
  ylabel = "Values",
  arrow = TRUE,
  dateFont = 3,
  dateInterval = FALSE,
  sizeRange = c(1, 3),
  facetScales = "free",
  dateFormat = "\%d \%b \%y",
  n = nrow(data),
  ...
)
}
\arguments{
\item{data}{A data frame containing the time series data with required columns: "values_avg", "change_rate", and "date".}

\item{group}{(Optional) A string specifying the column name in `data` to use for grouping data in the plot. If NULL, no grouping is applied.}

\item{facet}{Logical indicating whether to facet the plot based on the `group` variable. If TRUE and `group` is NULL, an error is raised.}

\item{xlabel}{Label for the x-axis, defaults to "Rate of Change".}

\item{ylabel}{Label for the y-axis, defaults to "Values".}

\item{arrow}{Logical indicating whether to add an arrow to the end of each line, defaults to TRUE.}

\item{dateFont}{Numeric specifying the size of the date font, defaults to 3.}

\item{dateInterval}{Numeric specifying the interval at which date labels should be displayed. If FALSE, no date labels are shown.}

\item{sizeRange}{Numeric vector of length 2 specifying the range of line widths.}

\item{facetScales}{Character string indicating whether scales should be "fixed", "free_x", "free_y", or "free".}

\item{dateFormat}{Format for the date labels, defaults to d-b-y.}

\item{n}{Numeric specifying the number of points to interpolate along the spline, defaults to the number of rows in `data`.}

\item{...}{Additional arguments passed on to `ggplot2` layer functions.}
}
\value{
A `ggplot` object representing the helical plot.
}
\description{
Creates a helical plot to visualize time series data, emphasizing both
the magnitude and rate of change over time.
}
\examples{
# Assuming `dataPrep` is a data frame prepared with the required structure:

\dontrun{
heliPlot(dataPrep, group = "myGroup", arrow = TRUE, 
dateFont = 3, dateInterval = 30, sizeRange = c(1, 3))
}

}
