% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorPalette.R
\name{colorPalette}
\alias{colorPalette}
\title{Defines a color palette}
\usage{
colorPalette(n = NULL, type = "spectral", inv = F)
}
\arguments{
\item{n}{number of colors to produce}

\item{type}{sets the type of color palette. See Details}

\item{inv}{revert the order of colors}
}
\value{
retuns a vector of colors to be passed to \code{image} or \code{rasterImage}
}
\description{
This function defines a color palette and returns a vector of colors. The
paletts itself are adapted from the ColorBrewer project.
}
\details{
The parameter \code{type} controls the output palette type as follows:
\describe{
       \item{"spectral"}{spectral colors from blue to red}
       \item{"specrtalHalf"}{spectral colors from green to red}
       \item{"green"}{MultiHue yellow - green}
       \item{"blue"}{MultiHue yellow - green blue}
       \item{"orange"}{MultiHue yellow - orange - brown}
       \item{"red"}{MultiHue yellow - orange red}
       \item{"red-white-bule","bwr"}{red - white - blue colors}
       \item{"rainbow"}{reproduces the rainbow colorset}
       \item{"black-white","bw"}{gray scale colors}
       \item{"white-black","wb"}{gray scale colors from white to black}
       \item{"jet.colors","jc"}{dark blue to dark red}
       \item{"hzdr1"}{HZDR cooperate design colors}
       \item{"hzdr2"}{HZDR cooperate design colors}
}
If a vector of color names is supported, then a customized palette will be
calculated according to these colors.
}
\examples{
# default "spectral" palette
barplot(rep(1,10), col = colorPalette(10))

# custom color palette
barplot(rep(1,10), col = colorPalette(n = 10, type = c("red","blue","yellow")))
}
\references{
\url{www.ColorBrewer.org} by Cynthia A. Brewer, Geography, Pennsylvania State University
}

