% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/RapData.R, R/RapUnsolved.R,
%   R/RapSolved.R
\name{space.plot}
\alias{space.plot}
\alias{space.plot.RapData}
\alias{space.plot.RapUnsolved}
\alias{space.plot.RapSolved}
\title{Plot space}
\usage{
space.plot(x, species, space, ...)

\method{space.plot}{RapData}(
  x,
  species,
  space = 1,
  pu.color.palette = c("#4D4D4D4D", "#00FF0080", "#FFFF0080", "#FF00004D"),
  main = NULL,
  ...
)

\method{space.plot}{RapUnsolved}(
  x,
  species,
  space = 1,
  pu.color.palette = c("#4D4D4D4D", "#00FF0080", "#FFFF0080", "#FF00004D"),
  main = NULL,
  ...
)

\method{space.plot}{RapSolved}(
  x,
  species,
  space = 1,
  y = 0,
  pu.color.palette = c("#4D4D4D4D", "#00FF0080", "#FFFF0080", "#FF00004D"),
  main = NULL,
  ...
)
}
\arguments{
\item{x}{\code{\link[=RapData]{RapData()}}, \code{\link[=RapUnsolved]{RapUnsolved()}}, or
\code{\link[=RapSolved]{RapSolved()}} object.}

\item{species}{\code{character} name of species, or \code{integer} index for
species.}

\item{space}{\code{integer} index of attribute space.}

\item{...}{not used.}

\item{pu.color.palette}{\code{character} name of colors or color palette
(\code{\link[RColorBrewer:ColorBrewer]{RColorBrewer::brewer.pal()}}) to indicate planning unit
statuses. Defaults to \code{c("grey30", "green", "black", "red")} which
indicate non selected, selected, locked in, and locked out (respectively).}

\item{main}{\code{character} title for the plot. Defaults to \code{NULL} and
a default title is used.}

\item{y}{\code{integer} number specifying the solution to be plotted. The
value \code{0} can be used to plot the best solution.}
}
\description{
This function plots the distribution of planning units and the distribution
of demand points for a particular species in an attribute space.
Note that this function only works for attribute spaces with one, two, or
three dimensions.
}
\examples{
# load RapSolved objects
data(sim_ru, sim_rs)

# plot first species in first attribute space
space.plot(sim_ru, 1, 1)

# plot distribution of solutions for first species in first attribute space
space.plot(sim_rs, 1, 1)

}
