% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDM.R
\name{RDM}
\alias{RDM}
\title{Estimating tree-topology from allele frequency data}
\usage{
RDM(
  mat_allele_freq,
  outgroup,
  use = c("complete.obs", "pairwise.complete.obs", "everything", "all.obs",
    "na.or.complete")
)
}
\arguments{
\item{mat_allele_freq}{A \eqn{(P+1) \times L} matrix containing the allele frequencies, where there are \eqn{P} taxa, plus one outgroup, and \eqn{L} loci.}

\item{outgroup}{A variable that can be either the population name or a numerical row number of the outgroup data.}

\item{use}{Specify which part of data is used to compute the covariance matrix. The options are "\code{complete.obs}", "\code{pairwise.complete.obs}", "\code{everything}", "\code{all.obs}", and "\code{na.or.complete}". See \code{stats::cov} for more details.}
}
\value{
An estimated tree-topology in Newick format.
}
\description{
\code{RDM()} estimates a tree-topology from allele frequencies.
}
\details{
The input matrix is the observed values of the frequencies at tips \eqn{1, 2, ..., P, P+1}. A logit transformation is performed on the allele frequency data, so that the observed values are approximately normal (The logit transformation of r refers to \eqn{\log\frac{r}{1-r}}). The transformed matrix is converted into a data frame for further analyses.
}
\examples{
# A dataset "Human_Allele_Frequencies" is loaded with the package;
# it has allele frequencies in 44,000 sites for
# 5 human populations and one outgroup human population.

# check data dimension
dim(Human_Allele_Frequencies)

# run RDM function
rd_tre <- RDM(Human_Allele_Frequencies, outgroup = "San", use = "pairwise.complete.obs")

# result visualization
plot(rd_tre, use.edge.length = FALSE, cex = 0.5)

}
\references{
Jing Peng, Haseena Rajeevan, Laura Kubatko, and Arindam RoyChoudhury (2021) \emph{A fast likelihood approach for estimation of large phylogenies from continuous trait data}. Molecular Phylogenetics and Evolution 161 107142.
}
