% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/installation.R
\name{export_rang}
\alias{export_rang}
\title{Export The Resolved Result As Installation Script}
\usage{
export_rang(
  rang,
  path,
  rang_as_comment = TRUE,
  verbose = TRUE,
  lib = NA,
  cran_mirror = "https://cran.r-project.org/",
  check_cran_mirror = TRUE
)
}
\arguments{
\item{rang}{output from \code{\link[=resolve]{resolve()}}}

\item{path}{character, path of the exported installation script}

\item{rang_as_comment}{logical, whether to write resolved result and the steps to reproduce
the file to \code{path} as comment}

\item{verbose}{logical, pass to \code{\link[=install.packages]{install.packages()}}, the negated value is also passed as \code{quiet} to both \code{\link[=install.packages]{install.packages()}}
and \code{\link[=download.file]{download.file()}}.}

\item{lib}{character, pass to \code{\link[=install.packages]{install.packages()}}. By default, it is NA (to install the packages to the default location)}

\item{cran_mirror}{character, which CRAN mirror to use}

\item{check_cran_mirror}{logical, whether to check the CRAN mirror}
}
\value{
\code{path}, invisibly
}
\description{
This function exports the results from \code{\link[=resolve]{resolve()}} to an installation script that can be run in a fresh R environment.
}
\details{
The idea behind this is to determine the installation order of R packages locally. Then, the installation script can be depolyed to another
fresh R session to install R packages. \code{\link[=dockerize]{dockerize()}} is a more reasonable way because a fresh R session with all system requirements
is provided. The current approach does not work in R < 2.1.0.
}
\examples{
\donttest{
if (interactive()) {
    graph <- resolve(pkgs = c("openNLP", "LDAvis", "topicmodels", "quanteda"),
                    snapshot_date = "2020-01-16")
    export_rang(graph, "rang.R")
}
}
}
\references{
Ripley, B. (2005) \href{https://cran.r-project.org/doc/Rnews/Rnews_2005-1.pdf}{Packages and their Management in R 2.1.0.} R News, 5(1):8--11.
}
