% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strata_and_cluster_rs.R
\name{strata_and_cluster_rs_probabilities}
\alias{strata_and_cluster_rs_probabilities}
\title{Inclusion Probabilities: Stratified and Clustered Random Sampling}
\usage{
strata_and_cluster_rs_probabilities(strata = NULL, clusters = NULL,
  prob = NULL, prob_unit = NULL, n = NULL, n_unit = NULL,
  strata_n = NULL, strata_prob = NULL, check_inputs = TRUE)
}
\arguments{
\item{strata}{A vector of length N that indicates which stratum each unit belongs to.}

\item{clusters}{A vector of length N that indicates which cluster each unit belongs to.}

\item{prob}{Use for a design in which either floor(N_clusters_stratum*prob) or ceiling(N_clusters_stratum*prob) clusters are sampled within each stratum. The probability of being sampled is exactly prob because with probability 1-prob, floor(N_clusters_stratum*prob) clusters will be sampled and with probability prob, ceiling(N_clusters_stratum*prob) clusters will be sampled. prob must be a real number between 0 and 1 inclusive. (optional)}

\item{prob_unit}{Must of be of length N. tapply(prob_unit, blocks, unique) will be passed to \code{strata_prob}.}

\item{n}{Use for a design in which the scalar n describes the fixed number of units to sample in each stratum. This number does not vary across strata.}

\item{n_unit}{Must be of length N. tapply(m_unit, blocks, unique) will be passed to \code{strata_n}.}

\item{strata_n}{Use for a design in which strata_n describes the number of units to sample within each stratum.}

\item{strata_prob}{Use for a design in which strata_prob describes the probability of being sampled within each stratum. Differs from prob in that the probability of being sampled can vary across strata.}

\item{check_inputs}{logical. Defaults to TRUE.}
}
\value{
A vector length N indicating the probability of being sampled.
}
\description{
Inclusion Probabilities: Stratified and Clustered Random Sampling
}
\examples{

clusters <- rep(letters, times = 1:26)

strata <- rep(NA, length(clusters))
strata[clusters \%in\% letters[1:5]] <- "stratum_1"
strata[clusters \%in\% letters[6:10]] <- "stratum_2"
strata[clusters \%in\% letters[11:15]] <- "stratum_3"
strata[clusters \%in\% letters[16:20]] <- "stratum_4"
strata[clusters \%in\% letters[21:26]] <- "stratum_5"

table(strata, clusters)

probs <- strata_and_cluster_rs_probabilities(strata = strata,
                                         clusters = clusters)

table(probs, strata)
table(probs, clusters)


probs <- strata_and_cluster_rs_probabilities(clusters = clusters,
                                         strata = strata,
                                         prob = .5)

table(probs, clusters)
table(probs, strata)

probs <- strata_and_cluster_rs_probabilities(clusters = clusters,
                                         strata = strata,
                                         strata_n = c(2, 3, 2, 3, 2))

table(probs, clusters)
table(probs, strata)

probs <- strata_and_cluster_rs_probabilities(clusters = clusters,
                                         strata = strata,
                                         strata_prob = c(.1, .2, .3, .4, .5))

table(probs, clusters)
table(probs, strata)


}
