% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obtain_num_permutations.R
\name{obtain_num_permutations}
\alias{obtain_num_permutations}
\title{Obtain the Number of Possible Permutations from a Random Assignment Declaration}
\usage{
obtain_num_permutations(declaration)
}
\arguments{
\item{declaration}{A random assignment declaration, created by \code{\link{declare_ra}}.}
}
\value{
a scalar
}
\description{
Obtain the Number of Possible Permutations from a Random Assignment Declaration
}
\examples{

# complete

declaration <- declare_ra(N = 4)
perms <- obtain_permutation_matrix(declaration)
dim(perms)
obtain_num_permutations(declaration)

# blocked

blocks <- c("A", "A", "B", "B", "C", "C", "C")
declaration <- declare_ra(blocks = blocks)
perms <- obtain_permutation_matrix(declaration)
dim(perms)
obtain_num_permutations(declaration)

# clustered

clusters <- c("A", "B", "A", "B", "C", "C", "C")
declaration <- declare_ra(clusters = clusters)
perms <- obtain_permutation_matrix(declaration)
dim(perms)
obtain_num_permutations(declaration)

# large

declaration <- declare_ra(20)
choose(20, 10)
perms <- obtain_permutation_matrix(declaration)
dim(perms)

}
