% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randPar.R, R/abcdPar.R, R/bbcdPar.R,
%   R/ebcPar.R, R/bsdPar.R, R/chenPar.R, R/crPar.R, R/gbcdPar.R, R/hadaPar.R,
%   R/mpPar.R, R/pbrPar.R, R/rarPar.R, R/rpbrPar.R, R/tbdPar.R, R/rtbdPar.R,
%   R/udPar.R
\name{generateRandomSequences}
\alias{generateRandomSequences}
\alias{genSeq}
\alias{genSeq,abcdPar,numeric,numeric-method}
\alias{genSeq,abcdPar,numeric,missing-method}
\alias{genSeq,abcdPar,missing,numeric-method}
\alias{genSeq,abcdPar,missing,missing-method}
\alias{genSeq,bbcdPar,numeric,numeric-method}
\alias{genSeq,bbcdPar,numeric,missing-method}
\alias{genSeq,bbcdPar,missing,numeric-method}
\alias{genSeq,bbcdPar,missing,missing-method}
\alias{genSeq,ebcPar,numeric,numeric-method}
\alias{genSeq,ebcPar,missing,numeric-method}
\alias{genSeq,ebcPar,numeric,missing-method}
\alias{genSeq,ebcPar,missing,missing-method}
\alias{genSeq,bsdPar,numeric,numeric-method}
\alias{genSeq,bsdPar,numeric,missing-method}
\alias{genSeq,bsdPar,missing,numeric-method}
\alias{genSeq,bsdPar,missing,missing-method}
\alias{genSeq,chenPar,numeric,numeric-method}
\alias{genSeq,chenPar,numeric,missing-method}
\alias{genSeq,chenPar,missing,numeric-method}
\alias{genSeq,chenPar,missing,missing-method}
\alias{genSeq,crPar,numeric,numeric-method}
\alias{genSeq,crPar,missing,numeric-method}
\alias{genSeq,crPar,numeric,missing-method}
\alias{genSeq,crPar,missing,missing-method}
\alias{genSeq,gbcdPar,numeric,numeric-method}
\alias{genSeq,gbcdPar,numeric,missing-method}
\alias{genSeq,gbcdPar,missing,numeric-method}
\alias{genSeq,gbcdPar,missing,missing-method}
\alias{genSeq,hadaPar,numeric,numeric-method}
\alias{genSeq,hadaPar,missing,numeric-method}
\alias{genSeq,hadaPar,numeric,missing-method}
\alias{genSeq,hadaPar,missing,missing-method}
\alias{genSeq,mpPar,numeric,numeric-method}
\alias{genSeq,mpPar,missing,numeric-method}
\alias{genSeq,mpPar,numeric,missing-method}
\alias{genSeq,mpPar,missing,missing-method}
\alias{genSeq,pbrPar,missing,numeric-method}
\alias{genSeq,pbrPar,numeric,numeric-method}
\alias{genSeq,pbrPar,missing,missing-method}
\alias{genSeq,pbrPar,numeric,missing-method}
\alias{genSeq,rarPar,numeric,numeric-method}
\alias{genSeq,rarPar,missing,numeric-method}
\alias{genSeq,rarPar,numeric,missing-method}
\alias{genSeq,rarPar,missing,missing-method}
\alias{genSeq,rpbrPar,missing,numeric-method}
\alias{genSeq,rpbrPar,numeric,numeric-method}
\alias{genSeq,rpbrPar,missing,missing-method}
\alias{genSeq,rpbrPar,numeric,missing-method}
\alias{genSeq,tbdPar,numeric,numeric-method}
\alias{genSeq,tbdPar,missing,numeric-method}
\alias{genSeq,tbdPar,numeric,missing-method}
\alias{genSeq,tbdPar,missing,missing-method}
\alias{genSeq,rtbdPar,numeric,numeric-method}
\alias{genSeq,rtbdPar,missing,numeric-method}
\alias{genSeq,rtbdPar,numeric,missing-method}
\alias{genSeq,rtbdPar,missing,missing-method}
\alias{genSeq,udPar,numeric,numeric-method}
\alias{genSeq,udPar,missing,numeric-method}
\alias{genSeq,udPar,numeric,missing-method}
\alias{genSeq,udPar,missing,missing-method}
\title{Generate random sequences}
\usage{
genSeq(obj, r, seed)

\S4method{genSeq}{abcdPar,numeric,numeric}(obj, r, seed)

\S4method{genSeq}{abcdPar,numeric,missing}(obj, r, seed)

\S4method{genSeq}{abcdPar,missing,numeric}(obj, r, seed)

\S4method{genSeq}{abcdPar,missing,missing}(obj, r, seed)

\S4method{genSeq}{bbcdPar,numeric,numeric}(obj, r, seed)

\S4method{genSeq}{bbcdPar,numeric,missing}(obj, r, seed)

\S4method{genSeq}{bbcdPar,missing,numeric}(obj, r, seed)

\S4method{genSeq}{bbcdPar,missing,missing}(obj, r, seed)

\S4method{genSeq}{ebcPar,numeric,numeric}(obj, r, seed)

\S4method{genSeq}{ebcPar,missing,numeric}(obj, r, seed)

\S4method{genSeq}{ebcPar,numeric,missing}(obj, r, seed)

\S4method{genSeq}{ebcPar,missing,missing}(obj, r, seed)

\S4method{genSeq}{bsdPar,numeric,numeric}(obj, r, seed)

\S4method{genSeq}{bsdPar,numeric,missing}(obj, r, seed)

\S4method{genSeq}{bsdPar,missing,numeric}(obj, r, seed)

\S4method{genSeq}{bsdPar,missing,missing}(obj, r, seed)

\S4method{genSeq}{chenPar,numeric,numeric}(obj, r, seed)

\S4method{genSeq}{chenPar,numeric,missing}(obj, r, seed)

\S4method{genSeq}{chenPar,missing,numeric}(obj, r, seed)

\S4method{genSeq}{chenPar,missing,missing}(obj, r, seed)

\S4method{genSeq}{crPar,numeric,numeric}(obj, r, seed)

\S4method{genSeq}{crPar,missing,numeric}(obj, r, seed)

\S4method{genSeq}{crPar,numeric,missing}(obj, r, seed)

\S4method{genSeq}{crPar,missing,missing}(obj, r, seed)

\S4method{genSeq}{gbcdPar,numeric,numeric}(obj, r, seed)

\S4method{genSeq}{gbcdPar,numeric,missing}(obj, r, seed)

\S4method{genSeq}{gbcdPar,missing,numeric}(obj, r, seed)

\S4method{genSeq}{gbcdPar,missing,missing}(obj, r, seed)

\S4method{genSeq}{hadaPar,numeric,numeric}(obj, r, seed)

\S4method{genSeq}{hadaPar,missing,numeric}(obj, r, seed)

\S4method{genSeq}{hadaPar,numeric,missing}(obj, r, seed)

\S4method{genSeq}{hadaPar,missing,missing}(obj, r, seed)

\S4method{genSeq}{mpPar,numeric,numeric}(obj, r, seed)

\S4method{genSeq}{mpPar,missing,numeric}(obj, r, seed)

\S4method{genSeq}{mpPar,numeric,missing}(obj, r, seed)

\S4method{genSeq}{mpPar,missing,missing}(obj, r, seed)

\S4method{genSeq}{pbrPar,missing,numeric}(obj, r, seed)

\S4method{genSeq}{pbrPar,numeric,numeric}(obj, r, seed)

\S4method{genSeq}{pbrPar,missing,missing}(obj, r, seed)

\S4method{genSeq}{pbrPar,numeric,missing}(obj, r, seed)

\S4method{genSeq}{rarPar,numeric,numeric}(obj, r, seed)

\S4method{genSeq}{rarPar,missing,numeric}(obj, r, seed)

\S4method{genSeq}{rarPar,numeric,missing}(obj, r, seed)

\S4method{genSeq}{rarPar,missing,missing}(obj, r, seed)

\S4method{genSeq}{rpbrPar,missing,numeric}(obj, r, seed)

\S4method{genSeq}{rpbrPar,numeric,numeric}(obj, r, seed)

\S4method{genSeq}{rpbrPar,missing,missing}(obj, r, seed)

\S4method{genSeq}{rpbrPar,numeric,missing}(obj, r, seed)

\S4method{genSeq}{tbdPar,numeric,numeric}(obj, r, seed)

\S4method{genSeq}{tbdPar,missing,numeric}(obj, r, seed)

\S4method{genSeq}{tbdPar,numeric,missing}(obj, r, seed)

\S4method{genSeq}{tbdPar,missing,missing}(obj, r, seed)

\S4method{genSeq}{rtbdPar,numeric,numeric}(obj, r, seed)

\S4method{genSeq}{rtbdPar,missing,numeric}(obj, r, seed)

\S4method{genSeq}{rtbdPar,numeric,missing}(obj, r, seed)

\S4method{genSeq}{rtbdPar,missing,missing}(obj, r, seed)

\S4method{genSeq}{udPar,numeric,numeric}(obj, r, seed)

\S4method{genSeq}{udPar,missing,numeric}(obj, r, seed)

\S4method{genSeq}{udPar,numeric,missing}(obj, r, seed)

\S4method{genSeq}{udPar,missing,missing}(obj, r, seed)
}
\arguments{
\item{obj}{object specifying the randomization procedure, see \code{\link{randPar}}
or \code{\link{createParam}}.}

\item{r}{numeric indicating the number of random sequences to be generated at
random, or missing.}

\item{seed}{a single value, interpreted as an integer, that specifies the seed
for the random number generation.}
}
\value{
An object inheriting from \linkS4class{randSeq}, representing the \code{r}
randomization sequences generated at random for the specified randomization procedure.
The output consists of the parameters used for the generation of the
randomization sequences (see \code{\link{createParam}}) and the matrix \code{M}
that stores the randomization sequences in its \code{r} rows.
If \code{r} is missing, one sequence is generated by default.
}
\description{
Generates randomization sequences from a given randomization procedure.
}
\details{
\code{genSeq} generates randomization sequences for a randomization
procedure as defined by the input parameters.
\code{genSeq} has two modes, according to the input.
\enumerate{
\item \code{genSeq(obj,r)}: gives \code{r} random sequences from the
design specified by \code{obj}, along with the parameters stored in \code{obj}.
\item \code{genSeq(obj)}: gives one random sequences from the
design specified by \code{obj}, along with the parameters stored in \code{obj}.
}
The sequences are generated by using the Monte-Carlo sampling technique to sample
from the true distribution of the sequences according to the randomization procedure
specified by \code{obj}.
The parameters of the randomization procedure are saved along with the sequences
to ensure reproducibility of the results.
}
\examples{
# generate randomization sequences using Complete Randomization for N = 10
myPar <- crPar(10)
genSeq(myPar, 4)
genSeq(myPar)

# generate randomization sequences using the Random Allocation Rule for N = 10
myPar <- rarPar(10)
genSeq(myPar, 4)
genSeq(myPar)

# generate randomization sequences using the Maximal Procedure with mti = 2 and N = 10
myPar <- mpPar(10, 2)
genSeq(myPar, 4)
genSeq(myPar)

}
