% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/static_inference.R
\name{importance_sampling_from_stream}
\alias{importance_sampling_from_stream}
\title{Runs Importance sampling evidence updating from an AMIDST data stream}
\usage{
importance_sampling_from_stream(network, target_variable, evidence_variables,
  input_stream, sample_size, parallel = T, seed = 3L)
}
\arguments{
\item{network}{a java object of class \code{BayesianNetwork} over which the
computations will be carried out}

\item{target_variable}{a string representing
the name of variable whose posterior distribution will be computed}

\item{evidence_variables}{a vector with the names of the observed variables}

\item{input_stream}{and AMIDST data stream}

\item{sample_size}{the sample size to be used during the simulation}

\item{parallel}{a \code{boolean} indicating whether or not the items in the
sample will be generated in parallel (when allowed by the system)}

\item{seed}{the seed for the genertion of random numbers}
}
\value{
a \code{data.frame} with the posterior distribution of the target
variable for each item in the strea
}
\description{
Runs Importance sampling evidence updating from an AMIDST data stream
}
\note{
The function computes the posterior distribution given some evidence
for all the items in the input stream.
}
\examples{
network <- load_amidst_bn(system.file("extdata","WasteIncinerator.bn",
package="ramidst"))
sample_stream <- amidst_data_stream(system.file("extdata",
"WasteIncineratorSample.arff",package="ramidst"))
posterior <- importance_sampling_from_stream(network,"B",c("F","E"),
sample_stream,50L)
posterior
posterior <- importance_sampling_from_stream(network,"L",c("F","E"),
sample_stream,50L)
posterior
}
\references{
A. Salmeron, D. Ramos-Lopez, H. Borchani, A.M.
Martinez, A.R. Masegosa, A. Fernandez, H. Langseth, A.L.
Madsen, T.D. Nielsen (2015) Parallel importance sampling in conditional
linear Gaussian networks. CAEPIA'2015. Lecture Notes in Artificial
Intelligence 9422, 36-46.
}

