/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.inference;

import eu.amidst.core.datastream.DataStream;
import eu.amidst.core.distribution.Distribution;
import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.exponentialfamily.EF_ConditionalDistribution;
import eu.amidst.core.exponentialfamily.EF_UnivariateDistribution;
import eu.amidst.core.inference.messagepassing.Node;
import eu.amidst.core.inference.messagepassing.VMP;
import eu.amidst.core.utils.Utils;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.Variable;
import eu.amidst.dynamic.datastream.DynamicDataInstance;
import eu.amidst.dynamic.exponentialfamily.EF_DynamicBayesianNetwork;
import eu.amidst.dynamic.inference.InferenceAlgorithmForDBN;
import eu.amidst.dynamic.inference.InferenceEngineForDBN;
import eu.amidst.dynamic.learning.parametric.DynamicNaiveBayesClassifier;
import eu.amidst.dynamic.models.DynamicBayesianNetwork;
import eu.amidst.dynamic.utils.DataSetGenerator;
import eu.amidst.dynamic.variables.DynamicAssignment;
import eu.amidst.dynamic.variables.HashMapDynamicAssignment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class DynamicVMP
implements InferenceAlgorithmForDBN {
    DynamicBayesianNetwork model;
    EF_DynamicBayesianNetwork ef_model;
    DynamicAssignment assignment = new HashMapDynamicAssignment(0);
    List<Node> nodesTimeT;
    List<Node> nodesClone;
    VMP vmpTime0 = new VMP();
    VMP vmpTimeT = new VMP();
    long timeID;
    long sequenceID;

    public DynamicVMP() {
        this.setSeed(0);
        this.timeID = -1L;
    }

    public void setSeed(int seed) {
        this.vmpTime0.setSeed(seed);
        this.vmpTimeT.setSeed(seed);
    }

    @Override
    public void setModel(DynamicBayesianNetwork model_) {
        this.model = model_;
        this.ef_model = new EF_DynamicBayesianNetwork(this.model);
        this.vmpTime0.setEFModel(this.ef_model.getBayesianNetworkTime0());
        this.nodesTimeT = this.ef_model.getBayesianNetworkTimeT().getDistributionList().stream().map(dist -> new Node((EF_ConditionalDistribution)dist)).collect(Collectors.toList());
        this.nodesClone = this.ef_model.getBayesianNetworkTime0().getDistributionList().stream().map(dist -> {
            Variable temporalClone = this.model.getDynamicVariables().getInterfaceVariable(dist.getVariable());
            Object uni = ((UnivariateDistribution)((DistributionType)temporalClone.getDistributionType()).newUnivariateDistribution()).toEFUnivariateDistribution();
            Node node = new Node((EF_ConditionalDistribution)uni);
            node.setActive(false);
            return node;
        }).collect(Collectors.toList());
        ArrayList<Node> allNodes = new ArrayList<Node>();
        allNodes.addAll(this.nodesTimeT);
        allNodes.addAll(this.nodesClone);
        this.vmpTimeT.setNodes(allNodes);
        this.vmpTimeT.updateChildrenAndParents();
    }

    @Override
    public DynamicBayesianNetwork getOriginalModel() {
        return this.model;
    }

    @Override
    public void reset() {
        this.timeID = -1L;
        this.sequenceID = -1L;
        this.vmpTime0.resetQs();
        this.vmpTimeT.resetQs();
    }

    @Override
    public void addDynamicEvidence(DynamicAssignment assignment_) {
        if (this.sequenceID != -1L && this.sequenceID != assignment_.getSequenceID()) {
            throw new IllegalArgumentException("The sequence ID does not match. If you want to change the sequence, invoke reset method");
        }
        if (this.timeID >= assignment_.getTimeID()) {
            throw new IllegalArgumentException("The provided assignment is not posterior to the previous provided assignment.");
        }
        this.assignment = assignment_;
    }

    @Override
    public <E extends UnivariateDistribution> E getFilteredPosterior(Variable var) {
        return this.getTimeIDOfPosterior() == 0L ? this.vmpTime0.getPosterior(var) : this.vmpTimeT.getPosterior(var);
    }

    private static void moveNodeQDist(Node toTemporalCloneNode, Node fromNode) {
        EF_UnivariateDistribution uni = fromNode.getQDist().deepCopy(toTemporalCloneNode.getMainVariable());
        toTemporalCloneNode.setPDist(uni);
        toTemporalCloneNode.setQDist(uni);
    }

    @Override
    public <E extends UnivariateDistribution> E getPredictivePosterior(Variable var, int nTimesAhead) {
        if (this.timeID == -1L) {
            this.vmpTime0.setEvidence(null);
            this.vmpTime0.runInference();
            this.vmpTime0.getNodes().stream().filter(node -> !node.isObserved()).forEach(node -> {
                Variable temporalClone = this.model.getDynamicVariables().getInterfaceVariable(node.getMainVariable());
                DynamicVMP.moveNodeQDist(this.vmpTimeT.getNodeOfVar(temporalClone), node);
            });
            this.moveWindow(nTimesAhead - 1);
            E resultQ = this.getFilteredPosterior(var);
            this.vmpTime0.resetQs();
            this.vmpTimeT.resetQs();
            return resultQ;
        }
        HashMap map = new HashMap();
        this.vmpTimeT.getNodes().stream().filter(node -> !node.isObserved()).forEach(node -> map.put(node.getMainVariable(), node.getQDist().deepCopy()));
        this.moveWindow(nTimesAhead);
        E resultQ = this.getFilteredPosterior(var);
        map.entrySet().forEach(e -> this.vmpTimeT.getNodeOfVar((Variable)e.getKey()).setQDist((EF_UnivariateDistribution)e.getValue()));
        return resultQ;
    }

    @Override
    public long getTimeIDOfPosterior() {
        return this.timeID;
    }

    @Override
    public long getTimeIDOfLastEvidence() {
        return this.assignment.getTimeID();
    }

    @Override
    public void runInference() {
        if (this.timeID == -1L && this.assignment.getTimeID() > 0L) {
            this.vmpTime0.setEvidence(null);
            this.vmpTime0.runInference();
            this.timeID = 0L;
            this.vmpTime0.getNodes().stream().filter(node -> !node.isObserved()).forEach(node -> {
                Variable temporalClone = this.model.getDynamicVariables().getInterfaceVariable(node.getMainVariable());
                DynamicVMP.moveNodeQDist(this.vmpTimeT.getNodeOfVar(temporalClone), node);
            });
        }
        if (this.assignment.getTimeID() == 0L) {
            this.vmpTime0.setEvidence(this.assignment);
            this.vmpTime0.runInference();
            this.timeID = 0L;
            this.vmpTime0.getNodes().stream().filter(node -> !node.isObserved()).forEach(node -> {
                Variable temporalClone = this.model.getDynamicVariables().getInterfaceVariable(node.getMainVariable());
                DynamicVMP.moveNodeQDist(this.vmpTimeT.getNodeOfVar(temporalClone), node);
            });
        } else {
            if (this.assignment.getTimeID() - this.timeID > 1L) {
                this.moveWindow((int)(this.assignment.getTimeID() - this.timeID - 1L));
            }
            this.timeID = this.assignment.getTimeID();
            this.vmpTimeT.setEvidence(this.assignment);
            this.vmpTimeT.runInference();
            this.vmpTimeT.getNodes().stream().filter(node -> !node.getMainVariable().isInterfaceVariable()).filter(node -> !node.isObserved()).forEach(node -> {
                Variable temporalClone = this.model.getDynamicVariables().getInterfaceVariable(node.getMainVariable());
                DynamicVMP.moveNodeQDist(this.vmpTimeT.getNodeOfVar(temporalClone), node);
            });
        }
    }

    private void moveWindow(int nsteps) {
        HashMapDynamicAssignment newassignment = null;
        if (this.assignment != null) {
            newassignment = new HashMapDynamicAssignment(this.model.getNumberOfDynamicVars());
            for (Variable var : this.model.getDynamicVariables()) {
                newassignment.setValue(this.model.getDynamicVariables().getInterfaceVariable(var), this.assignment.getValue(var));
                newassignment.setValue(var, Utils.missingValue());
            }
        }
        for (int i = 0; i < nsteps; ++i) {
            this.vmpTimeT.setEvidence(newassignment);
            this.vmpTimeT.runInference();
            this.vmpTimeT.getNodes().stream().filter(node -> !node.getMainVariable().isInterfaceVariable()).filter(node -> !node.isObserved()).forEach(node -> {
                Variable temporalClone = this.model.getDynamicVariables().getInterfaceVariable(node.getMainVariable());
                DynamicVMP.moveNodeQDist(this.vmpTimeT.getNodeOfVar(temporalClone), node);
            });
            newassignment = null;
        }
    }

    public static void main(String[] arguments) throws IOException, ClassNotFoundException {
        DataStream<DynamicDataInstance> data = DataSetGenerator.generate(20, 10000, 10, 0);
        DynamicNaiveBayesClassifier model = new DynamicNaiveBayesClassifier();
        model.setClassVarID(0);
        model.setParallelMode(true);
        model.learn(data);
        DynamicBayesianNetwork bn = model.getDynamicBNModel();
        data = DataSetGenerator.generate(50, 10000, 10, 0);
        InferenceEngineForDBN.setInferenceAlgorithmForDBN(new DynamicVMP());
        InferenceEngineForDBN.setModel(bn);
        Variable defaultVar = bn.getDynamicVariables().getVariableByName("DiscreteVar0");
        Distribution dist = null;
        Distribution distAhead = null;
        for (DynamicDataInstance instance : data) {
            if (instance.getTimeID() == 0L && dist != null) {
                System.out.println(dist.toString());
                System.out.println(distAhead.toString());
                InferenceEngineForDBN.reset();
            }
            instance.setValue(defaultVar, Utils.missingValue());
            InferenceEngineForDBN.addDynamicEvidence(instance);
            InferenceEngineForDBN.runInference();
            dist = InferenceEngineForDBN.getFilteredPosterior(defaultVar);
            distAhead = InferenceEngineForDBN.getPredictivePosterior(defaultVar, 2);
        }
    }
}

