/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.inference;

import eu.amidst.core.distribution.Normal;
import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.inference.InferenceAlgorithm;
import eu.amidst.core.inference.messagepassing.VMP;
import eu.amidst.core.models.BayesianNetwork;
import eu.amidst.core.utils.BayesianNetworkGenerator;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.HashMapAssignment;
import eu.amidst.core.variables.Variable;
import java.util.function.Function;

public final class InferenceEngine {
    private static InferenceAlgorithm inferenceAlgorithm = new VMP();

    public static void setInferenceAlgorithm(InferenceAlgorithm inferenceAlgorithm) {
        InferenceEngine.inferenceAlgorithm = inferenceAlgorithm;
    }

    public static double getExpectedValue(Variable var, BayesianNetwork bayesianNetwork, Function<Double, Double> function) {
        inferenceAlgorithm.setModel(bayesianNetwork);
        inferenceAlgorithm.runInference();
        return inferenceAlgorithm.getExpectedValue(var, function);
    }

    public static <E extends UnivariateDistribution> E getPosterior(Variable var, BayesianNetwork bayesianNetwork, Assignment assignment) {
        inferenceAlgorithm.setModel(bayesianNetwork);
        inferenceAlgorithm.setEvidence(assignment);
        inferenceAlgorithm.runInference();
        return inferenceAlgorithm.getPosterior(var);
    }

    public static <E extends UnivariateDistribution> E getPosterior(Variable var, BayesianNetwork bayesianNetwork) {
        inferenceAlgorithm.setModel(bayesianNetwork);
        inferenceAlgorithm.runInference();
        return inferenceAlgorithm.getPosterior(var);
    }

    public static void main(String[] arguments) {
        BayesianNetworkGenerator.setNumberOfGaussianVars(2);
        BayesianNetworkGenerator.setNumberOfMultinomialVars(1, 2);
        BayesianNetwork bn = BayesianNetworkGenerator.generateNaiveBayes(2);
        HashMapAssignment assignment = new HashMapAssignment(1);
        Variable varB = bn.getVariables().getVariableById(0);
        assignment.setValue(varB, 0.7);
        Variable varA = bn.getVariables().getVariableById(1);
        Normal posteriorOfA = (Normal)InferenceEngine.getPosterior(varA, bn, assignment);
        System.out.println("P(A|B=0.7) = " + posteriorOfA.toString());
        VMP inf = new VMP();
        inf.setModel(bn);
        inf.setEvidence(assignment);
        inf.runInference();
        inf.getPosterior(varA);
    }
}

